/**
 * File Name	:	PaginatedOverridesListPanel.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Jan 5, 2012 6:23:33 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.msooverrides.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.ericsson.cms.sites.ui.client.Permissions;
import com.ericsson.cms.sites.ui.client.i18n.SitesConstants;
import com.ericsson.cms.sites.ui.client.i18n.SitesMessages;
import com.ericsson.cms.sites.ui.client.msooverrides.IUIMSOOverridesService;
import com.ericsson.cms.sites.ui.client.msooverrides.IUIMSOOverridesServiceAsync;
import com.ericsson.cms.sites.ui.client.msooverrides.MSOOverridesTab;
import com.ericsson.cms.sites.ui.client.msooverrides.MSOOverridesUtils;
import com.ericsson.cms.sites.ui.client.msooverrides.OverrideRow;
import com.ericsson.cms.sites.ui.client.msooverrides.events.AddEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.DeleteOverridesEvent;
import com.ericsson.cms.sites.ui.client.msooverrides.events.NeptuneFailureEvent;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.CookieStoreBasedPageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class PaginatedOverridesListPanel extends Composite implements IView {

	private final BusyIndicator busyIndicator = new BusyIndicator();

	private PaginatedOverridesListDataProvider dataProvider;
	
	private UIMSO uiMSO;
	
	private Map<Long, OverrideRow> overrideRowsMap;
	
    // widgets used in this view
	private ScrollContainer scrollPanel;
    private VerticalContainer mainContainer;
    private Table<Long, UIMSOOverrideRecord> table;
    private HorizontalContainer buttonsContainer;
    
    // spacing between the table and message panel
    private static final int SPACING = 2;

	private IUIMSOOverridesServiceAsync uiMSOOverridesService = GWT.create(IUIMSOOverridesService.class);

	private SitesConstants sitesConstants = GWT.create(SitesConstants.class);
	private SitesMessages sitesMessages = GWT.create(SitesMessages.class);

	private NeptuneSecurity security;

	public PaginatedOverridesListPanel() {
		this.overrideRowsMap = new HashMap<Long, OverrideRow>();
		this.dataProvider = new PaginatedOverridesListDataProvider(this);
		init();
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#reportFailure(java.lang.Throwable)
	 */
	@Override
	public void reportFailure(Throwable caught) {
		Window.alert(caught.getLocalizedMessage());
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#getParentContainer()
	 */
	@Override
	public Widget getParentContainer() {
		return mainContainer;
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#cleanup()
	 */
	@Override
	public void cleanup() {
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#refresh(java.lang.String)
	 */
	@Override
	public void refresh(String infoMessage) {
//		Window.alert("refresh() called");
		mainContainer.clear();
		setContainers();
        this.table.getPageFeature().setPageNumber(1);
		this.overrideRowsMap.clear();
		this.table.showListView();
        this.table.refresh();
//        this.table.updateAnchor();
//        show(infoMessage);		
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#show(java.lang.String)
	 */
	@Override
	public void show(String infoMessage) {
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#getSeletedRecordIds()
	 */
	@Override
	public List<Long> getSeletedRecordIds() {
        List<Long> selectedRecordIds = new ArrayList<Long>();
		List<UIMSOOverrideRecord> selectedRecords = table.getSelectedRecords();
		for (UIMSOOverrideRecord uiMSOOverrideRecord : selectedRecords) {
			selectedRecordIds.add(uiMSOOverrideRecord.getKey());
		}
		return selectedRecordIds;
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#getInputToExecution()
	 */
	@Override
	public IActionInput getInputToExecution() {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView#show(boolean)
	 */
	@Override
	public void show(boolean readOnly) {
		// TODO Auto-generated method stub

	}

	/*
	 * Ideally, use an event from data provider to notify view or use package protected code.
	 */
    public void handleGetRecordsRequest() {
    	showBusyIndicator();
    }
    
    /*
	 * Ideally, use an event from data provider to notify view. This is a 'shortcut'
	 */
    public void handleGetRecordsSuccessResponse(List<UIMSOOverrideRecord> records) {
		hideBusyIndicator();
	}

    /*
     * Ideally, use an event from data provider to notify view. This is a 'shortcut' 
     */
	public void handleGetRecordsFailureResponse(Throwable caught) {
		hideBusyIndicator();
	}

	public UIMSO getUiMSO() {
		return uiMSO;
	}

	public void setUiMSO(UIMSO uiMSO) {
		this.uiMSO = uiMSO;
	}

	public Map<Long, OverrideRow> getOverrideRowsMap() {
		return overrideRowsMap;
	}

	public void setOverrideRowsMap(Map<Long, OverrideRow> overrideRowsMap) {
		this.overrideRowsMap = overrideRowsMap;
	}

	public void addOverrideRow(OverrideRow overrideRow) {
		Long overrideId = overrideRow.getOverrideId();
		overrideRowsMap.put(overrideId, overrideRow);
	}
	
	private void init() {
    	initWidgets();
    	setContainers();
    }
    
    private void setContainers() {
    	mainContainer.add(table);
    }
    
    private void initWidgets() {
		scrollPanel = new ScrollContainer();
		initWidget(scrollPanel);

		mainContainer = new VerticalContainer();
        mainContainer.setSpacing(SPACING);
        mainContainer.setWidth("100%");
        scrollPanel.setWidget(mainContainer);
        
        table = new Table<Long, UIMSOOverrideRecord>(dataProvider);
        
		CookieStoreBasedPageFeatureImpl pageFeature = new CookieStoreBasedPageFeatureImpl("msoOverridesList");
		dataProvider.setPageFeature(pageFeature);
		table.addPageFeature(pageFeature);
		
		SortFeatureImpl<Long, UIMSOOverrideRecord> sortFeature = new SortFeatureImpl<Long, UIMSOOverrideRecord>(
				dataProvider.getDefaultSortColumn(), dataProvider.getDefaultSortOrder());
		for (Column<?, UIMSOOverrideRecord> sortableColumn : dataProvider.getSortableColumns()) {
			sortFeature.addSortableColumn(sortableColumn);
		}
		dataProvider.setSortFeature(sortFeature);
		table.addSortFeature(sortFeature);
		
        table.initialize( new NeptuneAsyncCallback<Void>() {
            @Override
            public void onNeptuneFailure(Throwable caught) {
            }

            @Override
            public void onNeptuneSuccess(Void result) {
            }
        } );
        
        buttonsContainer = new HorizontalContainer();
        
        Button saveAllOverridesButton = new Button(sitesConstants.saveOverridesButtonText());
        buttonsContainer.add(saveAllOverridesButton);
        saveAllOverridesButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
        saveAllOverridesButton.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				List<OverrideRow> overrideRows = new ArrayList<OverrideRow>(overrideRowsMap.values());

				MSOOverridesUtils msoOverridesUtils = new MSOOverridesUtils();
				msoOverridesUtils.saveAllOverrides(uiMSO, overrideRows);
			}
        	
        });

        Button addButton = new Button(sitesConstants.addButtonText());
        buttonsContainer.add(addButton);
        addButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
        addButton.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				MSOOverridesTab.getEventBus().fireEvent(new AddEvent());
			}
        	
        });
        
        Button deleteButton = new Button(sitesConstants.deleteButtonText());
        buttonsContainer.add(deleteButton);
        deleteButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
        deleteButton.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				deleteSelected();
			}
        	
        });
        

		table.registerWidgetOnActionContainer(buttonsContainer);
        
		security = NeptuneApplication.getApplication().getSecurity();

		if (!security.isUserInRole(Permissions.EDIT)) {
			addButton.setVisible(false);
			saveAllOverridesButton.setVisible(false);
			deleteButton.setVisible(false);
		}

    }

	protected void deleteSelected() {
		final List<Long> overrideIds = getSeletedRecordIds();
		if ((overrideIds != null) && (overrideIds.size() > 0)) {
			Set<Long> overrideIdsSet = new HashSet<Long>(overrideIds.size());
			overrideIdsSet.addAll(overrideIds);
			showBusyIndicator();
			uiMSOOverridesService.deleteMSOOverrides(overrideIdsSet, new NeptuneAsyncCallback<Void>() {

				@Override
				public void onNeptuneFailure(Throwable caught) {
					hideBusyIndicator();
					String failureMessage = sitesMessages.errorDeletingOverrides(caught.getLocalizedMessage());
					MSOOverridesTab.getEventBus().fireEvent(new NeptuneFailureEvent(failureMessage));
				}

				@Override
				public void onNeptuneSuccess(Void result) {
					MSOOverridesTab.getEventBus().fireEvent(new DeleteOverridesEvent(overrideIds));					
					hideBusyIndicator();
				}
				
			});
		}
		else { 
			MSOOverridesTab.getEventBus().fireEvent(new DeleteOverridesEvent(overrideIds));	
		}
		
	}
	
    private void showBusyIndicator() {
    	busyIndicator.center();
    }

    private void hideBusyIndicator() {
    	busyIndicator.hide();
    }

	public void updateSize(int offsetWidth, int offsetHeight) {
		int height = Window.getClientHeight() - offsetHeight;
		scrollPanel.setHeight(height + "px");
	}


}
