/**
 * File Name	:	TextBoxView.java
 * Created By	:	Sanjay Khattar (sanjay.khattar@ericsson.com)
 * Date Created	:	Oct 18, 2012 7:42:14 PM
 * Purpose		:	
 *
 * (c) Ericsson Television Inc. 
 */
package com.ericsson.cms.sites.ui.client.msooverrides.list;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.ViewBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

/**
 * @author esakhat (sanjay.khattar@ericsson.com)
 *
 */
public class TextBoxView extends ViewBase<String> {

	protected SimpleContainer simpleContainer;
	protected TextBoxWidget textBox;
	
	/**
	 * @param value
	 */
	public TextBoxView(String value, boolean readOnly) {
		super(value);
		textBox.setEnabled(!readOnly);
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View#getWidget()
	 */
	@Override
	public SimpleContainer getWidget() {
		return simpleContainer;
	}

	public TextBoxWidget getTextBoxWidget() {
		return textBox;
	}
	
	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View#release()
	 */
	@Override
	public void release() {
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.ViewBase#getViewValue()
	 */
	@Override
	protected String getViewValue() {
		return textBox.getText();
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.ViewBase#setViewValue(java.lang.Object)
	 */
	@Override
	protected void setViewValue(String value) {
		textBox.setText(value);
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.ViewBase#preInitialValueSet()
	 */
	@Override
	protected void preInitialValueSet() {
		simpleContainer = new SimpleContainer();
		textBox = new TextBoxWidget();
		simpleContainer.add(textBox);
	}

}
