package com.ericsson.cms.sites.ui.client.portlet;

import java.util.List;
import java.util.Map;

import com.ericsson.cms.sites.ui.client.portlet.distribution.DistributionPortletData;
import com.ericsson.cms.sites.ui.client.portlet.distribution.DistributionPortletRecord;
import com.ericsson.cms.sites.ui.client.portlet.distribution.IDistributionPortletService;
import com.ericsson.cms.sites.ui.client.portlet.distribution.IDistributionPortletServiceAsync;
import com.ericsson.cms.sites.ui.client.portlet.distribution.PortletConstants;
import com.ericsson.cms.sites.ui.client.portlet.distribution.TitleMetadata;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationService;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;

public class DistributionPortlet extends Portlet{
	
	private NeptuneSecurity security;
	
	private FlexTableContainer table;
	
	private IDistributionPortletServiceAsync portletService;
	
	private SpecificationServiceAsync tableService;
	
	private Timer refreshTimer;
	
	private PortletConstants constants;
	
	private TitleClientBundle titleBundle;
	
	private static final String TABLE_NAME = "title.portlet.Metadata";
	
	private String DISTRIBUTION_PORTLET_REFRESH_KEY = "site.portlets.distribution.refreshTime";
	
	private static final String CONTENT_VIEW_PERMISSION = "AssetManagement_View";
	
	private int DEFAULT_REFRESH = 60; // in seconds
	
	private int refreshPeriod;
	
	private UiTable uiTable;
	
	public DistributionPortlet(final NeptuneSecurity security, Map<String,String> info){
	        super("DISTRIBUTION");
		this.security = security;
		this.refreshPeriod = getRefreshPeriod(info);
		
		portletService = GWT.create(IDistributionPortletService.class);
		
		tableService = GWT.create(SpecificationService.class);
		
		constants = GWT.create(PortletConstants.class);
		
		titleBundle = new TitleClientBundle();
		
		setTitle(constants.portletHeader());
		setDisplayName(constants.portletHeader());
		
		table = new FlexTableContainer();
		table.setCellSpacing(0);
		table.setStyleName("portletTable");
		add(table);
		
		
		
		this.refreshTimer = new Timer() {
			@Override
			public void run() {
				reload();
			}
		};
		EventHandler handler = new EventHandler();
		addDocumentAttachHandler(handler);
		addDocumentDetachHandler(handler);
	}
	
	private void reload(){
		initializeTable();
		portletService.getData(new NeptuneAsyncCallback<DistributionPortletData>(){
			@Override
			public void onNeptuneFailure(Throwable caught) {
			}

			@Override
			public void onNeptuneSuccess(DistributionPortletData data) {
				clearTableData();
				prepareTableHeader(data);
				populateTableData(data);
				update();
			}
			
		});
	}
	private void initializeTable(){
		// get table columns
		tableService.getTable(TABLE_NAME, new NeptuneAsyncCallback<UiTable>(){
			@Override
			public void onNeptuneFailure(Throwable caught) {
			}
			@Override
			public void onNeptuneSuccess(UiTable uiTable){
				setTable(uiTable);
			}
		});
	}
	
	private void setTable(UiTable table){
		uiTable = table;
		
	}
	
	private void prepareTableHeader(DistributionPortletData data){
		if(data.getCount() == 0)
			return;
		
		// add status column header first
		table.setWidget(0, 0, new LabelWidget(constants.status()));
		table.getCellFormatter().setStyleName(0, 0, "portlet-tableHeader");
		
		List<UiColumn> columns = uiTable.getColumns();
		if(columns == null)
			return;
		int colIndex = 1;
		for(int i = 0; i < columns.size(); i ++){
			UiColumn col = columns.get(i);
			
			String colHeader = col.getDisplayName();
			table.setWidget(0, colIndex, new LabelWidget(colHeader));
			table.getCellFormatter().setStyleName(0, colIndex, "portlet-tableHeader");
			colIndex++;
		}
	
	}
	
	private void clearTableData(){
		table.removeAllRows();
	}
	/**
	 * load data
	 * @param data
	 */
	private void populateTableData(DistributionPortletData data){
		List<DistributionPortletRecord> records = data.getRecords();
		if(records == null)
			return;
		int dataRow = 1;
		for(int i = 0; i < records.size(); i++){
			int colIndex = 0;
			DistributionPortletRecord record = records.get(i);
			List<TitleMetadata> metadata = record.getMetadata();
			//add distribution status data
			table.setWidget(dataRow, colIndex, buildStatusWidget(record.getAggregatedStatusName(),
					record.getTitleId()));
			table.getCellFormatter().setStyleName(dataRow, colIndex, "portlet-table-icons");
			
			// populate title metadata 
			colIndex++;
			populateTitleMetadata(dataRow, colIndex, metadata, record.getTitleId());
			dataRow++;
		}
	}
	/**
	 * currently assumes that always first metadata column is hyperlink. Ideally, this should
	 * come from specification table configuration
	 * @param row
	 * @param metadata
	 * @param titleId
	 */
	private void populateTitleMetadata(int row, int col, List<TitleMetadata> metadata, long titleId){
		if(metadata == null)
			return;
		
		for(int i = 0; i < metadata.size(); i++){
			int colIndex = col + i;
			// TODO: HACK should come from configuration
			if(colIndex == 1 && security.isUserInRole(CONTENT_VIEW_PERMISSION)) 
				table.setWidget(row, colIndex, new HyperlinkWidget(metadata.get(i).getValue(),"Content.Search.Id=" + titleId + "&Tab=Sites"));
			else
				table.setWidget(row, colIndex, new LabelWidget(metadata.get(i).getValue()));
			table.getCellFormatter().setStyleName(row, colIndex, "portlet-table-text");
			
		}
	}
	
	private Widget buildStatusWidget(String status, long titleId){
			return getImage(status);
	}
	
	private ImageWidget getImage(String status) {
		ImageWidget image = new ImageWidget();
		titleBundle.updateDistributionStatusIcon(image, status);
		return image;
	}
	/**
	 * gets refresh period from configuration
	 * @param info
	 * @return
	 */
	private int getRefreshPeriod(Map<String, String> info){
		String refreshPeriod = info.get(DISTRIBUTION_PORTLET_REFRESH_KEY);
		try{
			int refresh = Integer.parseInt(refreshPeriod.trim());
			if(refresh < DEFAULT_REFRESH) 
				refresh = DEFAULT_REFRESH; // validate if configured value is less than default 
			
			return refresh * 1000; // in millis
			
		}
		catch(Exception ex){
			return DEFAULT_REFRESH * 1000; // in millis
		}
	}
	/*
	 * Event Handling
	 */
	private final class EventHandler implements DocumentAttachHandler, DocumentDetachHandler {
		@Override
		public void onAttach(DocumentAttachEvent event) {
			refreshTimer.scheduleRepeating(refreshPeriod);
			reload();
		}

		@Override
		public void onDetach(DocumentDetachEvent event) {
			refreshTimer.cancel();
		}
	}
}
