package com.ericsson.cms.sites.ui.client.portlet.distribution;

import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;
/**
 * represents a row for Distribution Portlet. It contains informaton about the master title
 * and its aggregrated distribution status
 * 
 * @author Kinjal Mehta
 *
 */
public class DistributionPortletRecord implements IsSerializable {

	/*
	 * id of master title 
	 */
	private long titleId;
	 
	/*
	 * master title metadata 
	 */
	private List<TitleMetadata> metadata;
	
	/**
	 * aggregrated distribution status
	 */
	private String aggregatedStatusName;

	public DistributionPortletRecord(){
		
	}

	public DistributionPortletRecord(long titleId,
			List<TitleMetadata> metadata, String aggregatedStatusName) {
		this.titleId = titleId;
		this.metadata = metadata;
		this.aggregatedStatusName = aggregatedStatusName;
	}
	
	public long getTitleId() {
		return titleId;
	}

	public void setTitleId(long titleId) {
		this.titleId = titleId;
	}

	public List<TitleMetadata> getMetadata() {
		return metadata;
	}

	public void setMetadata(List<TitleMetadata> metadata) {
		this.metadata = metadata;
	}

	public String getAggregatedStatusName() {
		return aggregatedStatusName;
	}

	public void setAggregatedStatusName(String aggregatedStatusName) {
		this.aggregatedStatusName = aggregatedStatusName;
	}
	
}
