package com.ericsson.cms.sites.ui.client.tabs.schedules;

import com.ericsson.cms.sites.ui.client.entities.SchedulesCalendarData;
import com.ericsson.cms.sites.ui.client.entities.UISchedule;
import com.ericsson.cms.sites.ui.client.i18n.SitePartnerConstants;
import com.ericsson.cms.sites.ui.client.images.ISiteClientBundle;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLTable.RowFormatter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class CalendarWidget extends Composite {
	private class DateCell extends Composite {
		private ISiteClientBundle clientBundle = GWT.create(ISiteClientBundle.class);

		public DateCell(int date, final UISchedule schedule) {
			VerticalContainer panel = new VerticalContainer();
			panel.setSize("50px", "50px");
			panel.add(new LabelWidget(Integer.toString(date)));
			if(schedule != null) {
				ImageWidget widget = new ImageWidget();
				widget.addClickHandler(new ClickHandler() {
					@Override
					public void onClick(ClickEvent event) {
						History.newItem("PMM.Schedule?scheduleId=" + schedule.getId());
					}
				});
				if(schedule.isError())
					widget.setResource(clientBundle.scheduleError());
				else
					widget.setResource(clientBundle.schedule());
				widget.addStyleName("sites-schedules-scheduleLink");
				widget.setAltText("View Schedule");
				panel.add(widget);
			}
			initWidget(panel);
		}
	}
	
	private SitePartnerConstants constants = GWT.create(SitePartnerConstants.class);
	
	private FlexTableContainer table = new FlexTableContainer();

	public CalendarWidget() {
		initWidget(table);
	}
	
	public void show(SchedulesCalendarData data) {
		clear();
		
		RowFormatter rf = table.getRowFormatter();
		rf.addStyleName(0, "sites-schedules-calHead");
		
		table.setWidget(0, 0, new LabelWidget(constants.sun()));
		table.setWidget(0, 1, new LabelWidget(constants.mon()));
		table.setWidget(0, 2, new LabelWidget(constants.tue()));
		table.setWidget(0, 3, new LabelWidget(constants.wed()));
		table.setWidget(0, 4, new LabelWidget(constants.thu()));
		table.setWidget(0, 5, new LabelWidget(constants.fri()));
		table.setWidget(0, 6, new LabelWidget(constants.sat()));

		int rowIndex=1, colIndex=0, date=1;
		rf.addStyleName(rowIndex, "sites-schedules-calBody");
		while(true) {
			int day = colIndex+1;
			
			if(!(date == 1 && day < data.getBeginningDay())) {
				table.setWidget(rowIndex, colIndex, new DateCell(date, data.getSchedules().get(date)));
				
				if(date == data.getNumDays()) {
					while(colIndex++ < 6)
						table.setWidget(rowIndex, colIndex, null);
					break;
				} else {
					date++;
				}
			}
			
			if(colIndex == 6) {
				rowIndex++;
				rf.addStyleName(rowIndex, "sites-schedules-calBody");
				colIndex = 0;
			}
			else {
				++colIndex;
			}
		}
	}

	public void clear() {
		table.removeAllRows();
	};

}
