package com.ericsson.cms.sites.ui.client.tabs.schedules;

import java.util.Map;

import com.ericsson.cms.sites.ui.client.Anchors;
import com.ericsson.cms.sites.ui.client.ISiteTab;
import com.ericsson.cms.sites.ui.client.IUISitePartnerService;
import com.ericsson.cms.sites.ui.client.IUISitePartnerServiceAsync;
import com.ericsson.cms.sites.ui.client.Permissions;
import com.ericsson.cms.sites.ui.client.SitesTabContainer.SiteCRUDNotifier;
import com.ericsson.cms.sites.ui.client.entities.ScheduleTabInitData;
import com.ericsson.cms.sites.ui.client.entities.SchedulesCalendarData;
import com.ericsson.cms.sites.ui.client.entities.UISite;
import com.ericsson.cms.sites.ui.client.entities.UISiteType;
import com.ericsson.cms.sites.ui.client.i18n.SitePartnerConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class SchedulesTab extends Composite implements ISiteTab {
	private VerticalContainer mainPanel;
	private MessageArea messageArea;
	private FormContainer formContainer;
	private ListBoxWidget<Integer> monthValueWidget = new ListBoxWidget<Integer>();
	private ListBoxWidget<Integer> yearValueWidget = new ListBoxWidget<Integer>();
	private ButtonWidget searchButton;
	private ButtonWidget createButton;
	private CalendarWidget cal = new CalendarWidget();

	private BusyIndicator busyIndicator = new BusyIndicator();
	
	private IUISitePartnerServiceAsync service = GWT.create(IUISitePartnerService.class);
	private SitePartnerConstants constants = GWT.create(SitePartnerConstants.class);

	private UISite site;
	private long contextId;
	
	private NeptuneSecurity security;

	public SchedulesTab() {
		security = NeptuneApplication.getApplication().getSecurity();
		
		buildUI();
		initWidget(mainPanel);
	}
	
	private void buildUI() {
		mainPanel = new VerticalContainer();
		
		formContainer = new FormContainer(HorizontalContainer.ALIGN_LEFT);
		fillMonths();
		formContainer.addRow(constants.fieldLabelMonth(), monthValueWidget);
		formContainer.addRow(constants.fieldLabelYear(), yearValueWidget);
		
		searchButton = new ButtonWidget(constants.buttonLabelSearch(),
			new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					search();
				}
			});
		searchButton.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);
		formContainer.addButton(searchButton);
		
		createButton = new ButtonWidget(constants.buttonLabelCreate(),
				new ClickHandler() {
					@Override
					public void onClick(ClickEvent event) {
						create();
					}
				});
		createButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
		formContainer.addButton(createButton);
		
		mainPanel.add(formContainer);
		
		LabelWidget spacer = new LabelWidget();
		spacer.setHeight("30px");
		mainPanel.add(spacer);
		
		mainPanel.add(cal);
	}
	
	@Override
	public String getDisplayName() {
		return constants.schedulesTabName();
	}

	@Override
	public String getName() {
		return "Schedules";
	}

	@Override
	public void setCRUDNotifier(SiteCRUDNotifier crudNotifier) {
	}

	@Override
	public boolean setSite(UISite site, Map<String, String> params) {
		this.site = site;
		if(site == null)
			return false;
		boolean createButtonVisible = site.isActive() && security.isUserInRole(Permissions.SCHEDULES_CREATE) 
				&& security.isUserInRole(Permissions.SCHEDULER_CREATE)
				&& security.isUserInRole(Permissions.EDIT);
		createButton.setVisible(createButtonVisible);
		return (site.getType() != UISiteType.TRACKING);
	}
	
	@Override
	public void setSelected(boolean selected) {
		if(!selected || site == null)
			return;
		
		History.newItem(
				Anchors.getAnchor(site.getId(), site.getParentId(), getName()),
				false);
		
		showError(null);
		showInfo(null);
		
		busyIndicator.center();
		service.getScheduleTabInitData(site.getId(), new NeptuneAsyncCallback<ScheduleTabInitData>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				showError("Failed to initialize. Reason: "
						+ (caught != null ? caught.getLocalizedMessage() : ""));
				busyIndicator.hide();
			}
			
			@Override
			public void onNeptuneSuccess(ScheduleTabInitData result) {
				busyIndicator.hide();
				monthValueWidget.setSelectedItem(result.getDate().getMonth());
				setYears(result.getDate().getYear());
				SchedulesTab.this.contextId = result.getContextId();
				search();
			}
		});
	}

	private void fillMonths() {
		monthValueWidget.addItem(constants.jan(), 0);
		monthValueWidget.addItem(constants.feb(), 1);
		monthValueWidget.addItem(constants.mar(), 2);
		monthValueWidget.addItem(constants.apr(), 3);
		monthValueWidget.addItem(constants.may(), 4);
		monthValueWidget.addItem(constants.jun(), 5);
		monthValueWidget.addItem(constants.jul(), 6);
		monthValueWidget.addItem(constants.aug(), 7);
		monthValueWidget.addItem(constants.sep(), 8);
		monthValueWidget.addItem(constants.oct(), 9);
		monthValueWidget.addItem(constants.nov(), 10);
		monthValueWidget.addItem(constants.dec(), 11);
	}
	
	private void setYears(int cy) {
		yearValueWidget.clear();
		for(int i=cy+1; i>=cy-5; --i) {
			yearValueWidget.addItem(Integer.toString(i), i);
		}
		yearValueWidget.setSelectedItem(cy);
	}
	
	private void create() {
		History.newItem("PMM.Schedule.Create" + "?contextId=" + contextId);
	}
	
	private void search() {
		busyIndicator.center();
		service.getSchedulesCalendar(site.getId(), monthValueWidget.getSelectedItem(),
				yearValueWidget.getSelectedItem(),
				new NeptuneAsyncCallback<SchedulesCalendarData>() {
			public void onNeptuneFailure(Throwable caught) {
				cal.clear();
				busyIndicator.hide();
				showError("Unable to get schedules information. Reason: "
						+ caught != null ? caught.getLocalizedMessage() : null);
			};
			public void onNeptuneSuccess(SchedulesCalendarData result) {
				cal.show(result);
				busyIndicator.hide();
			}
		});
	}
	
	private void showError(String message) {
		messageArea.setErrorMessage(message);
	}

	private void showInfo(String message) {
		messageArea.setInfoMessage(message);
	}

	@Override
	protected void onUnload() {
		super.onUnload();
		busyIndicator.hide();
	}

	@Override
	public void setMessageArea(MessageArea messageArea) {
		this.messageArea = messageArea;		
	}
}
