/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.titlefilter;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.info.PagingInfo;
import com.ericsson.cms.criteria.info.SortOrder;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="titleFilter")
public class TitleFilter
implements Serializable {
    private static final long serialVersionUID = -7141846923378135851L;
    protected Integer titleFilterId;
    protected ExpNode rootNode;
    private int startIndex;
    private int maxCount;
    private String sortColumnName;
    private String sortColumnSection;
    private String sortOrder;
    private FieldType sortFieldType;
    private boolean appliesToGlobalTitles;
    private Collection<Integer> filterSiteIds;
    private boolean countIncluded;
    private CriteriaMode criteriaMode = CriteriaMode.MASTER;

    public TitleFilter() {
    }

    public TitleFilter(ExpNode rootNode, SortingInfo sortInfo, PagingInfo pagingInfo) {
        this.setRootNode(rootNode);
        this.setSortInfo(sortInfo);
        this.setPageInfo(pagingInfo);
    }

    public TitleFilter(ExpNode searchCriteria) {
        this.setSortInfo(null);
        this.setRootNode(searchCriteria);
    }

    @XmlElement(nillable=true)
    public ExpNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(ExpNode rootNode) {
        this.rootNode = rootNode;
    }

    @XmlTransient
    public SortingInfo getSortInfo() {
        if (this.sortColumnName == null || this.sortColumnName.isEmpty()) {
            return null;
        }
        return new SortingInfo(this.sortColumnName, SortOrder.valueOf((String)this.sortOrder), this.sortColumnSection, this.sortFieldType);
    }

    public void setSortInfo(SortingInfo sortInfo) {
        if (sortInfo == null) {
            this.sortColumnName = null;
            this.sortOrder = null;
            this.sortColumnSection = null;
            this.sortFieldType = null;
        } else {
            this.sortColumnName = sortInfo.getSortItemName();
            this.sortOrder = sortInfo.getOrder().name();
            this.sortColumnSection = sortInfo.getAssetType();
            this.sortFieldType = sortInfo.getFieldType();
        }
    }

    public void setTitleFilterId(Integer titleFilterId) {
        this.titleFilterId = titleFilterId;
    }

    @XmlAttribute
    public Integer getTitleFilterId() {
        return this.titleFilterId;
    }

    public boolean hasPagingInfo() {
        return this.maxCount > 0;
    }

    @XmlTransient
    public PagingInfo getPageInfo() {
        return new PagingInfo(this.startIndex, this.maxCount);
    }

    public void setPageInfo(PagingInfo pagingInfo) {
        if (pagingInfo == null) {
            this.startIndex = 0;
            this.maxCount = 0;
        } else {
            this.startIndex = pagingInfo.getStartIndex();
            this.maxCount = pagingInfo.getMaxRecordCount();
        }
    }

    public boolean hasCriteria() {
        if (this.rootNode == null) {
            return false;
        }
        if (this.rootNode instanceof ExpList) {
            return ((ExpList)this.rootNode).hasCriteria();
        }
        return true;
    }

    public Collection<Integer> getFilterSiteIds() {
        return this.filterSiteIds;
    }

    public void setFilterSiteIds(Collection<Integer> filterSiteIds) {
        this.filterSiteIds = filterSiteIds;
    }

    public boolean isAppliesToMasterTitles() {
        return this.appliesToGlobalTitles;
    }

    public void setAppliesToMasterTitles(boolean appliesToGlobalTitles) {
        this.appliesToGlobalTitles = appliesToGlobalTitles;
    }

    public void setSortFieldType(FieldType sortFieldType) {
        this.sortFieldType = sortFieldType;
    }

    public FieldType getSortFieldType() {
        return this.sortFieldType;
    }

    public boolean isCountIncluded() {
        return this.countIncluded;
    }

    public void setCountIncluded(boolean countIncluded) {
        this.countIncluded = countIncluded;
    }

    public CriteriaMode getCriteriaMode() {
        return this.criteriaMode;
    }

    public void setCriteriaMode(CriteriaMode criteriaMode) {
        this.criteriaMode = criteriaMode;
    }
}

