package com.tandbergtv.cms.portal.ui.title.client.criteria;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.Position;
import com.gwtext.client.widgets.*;  
import com.gwtext.client.widgets.event.ResizableListenerAdapter;
import com.gwtext.client.core.EventObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.LicenseTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.PMMTitleTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;

public class FieldSelector extends PopupPanel implements SelectionHandler<TreeItem> {
	private static final int BOX_HEIGHT_INT = 250;
	private static final String STYLE_IS_BRANCH = "gwt-TreeItem-Branch";
	private static final String STYLE_IS_LEAF = "gwt-TreeItem-Leaf";
	private static final String STYLE_FIELD_SELECTOR = "field-selector";
	
	private static Map<FieldSelectorMapKey, FieldSelector> fieldSelectorMap = new HashMap<FieldSelectorMapKey, FieldSelector>();

	private static class FieldSelectorMapKey {

		private CriteriaType critType;
		private UiCriteriaMode critMode;

		private FieldSelectorMapKey(CriteriaType critType, UiCriteriaMode critMode) {
			this.critType = critType;
			this.critMode = critMode;
		}

		@Override
		public int hashCode() {
			return (critMode.toString() + critType.toString()).hashCode();
		}

		@Override
		public boolean equals(Object value) {
			if (value == null || !(value instanceof FieldSelectorMapKey)) {
				return false;
			}
			FieldSelectorMapKey typedValue = (FieldSelectorMapKey) value;
			return typedValue.critMode.equals(critMode) && typedValue.critType.equals(critType);
		}
	}
	
	TreeResource images= new TreeResource();
	private TreeWidget tree = new TreeWidget(images);
	private TreeWidget fieldTree = new TreeWidget(images);
	private TreeWidget wholeTree = new TreeWidget(images);
	private FieldSelectorHandler handler;
	private int currentPosition = 0;
	private TreeItem selectedItem = null;
	private IFieldTreeObject treeObject;
	private VerticalPanel mainPanel = new VerticalPanel();
	private HorizontalPanel fieldPanel = new HorizontalPanel();
	private HorizontalPanel searchPanel = new HorizontalPanel();
	
	private HorizontalPanel expandPanel = new HorizontalPanel();
	private VerticalPanel leftContainer = new VerticalPanel();
	private VerticalPanel rightContainer = new VerticalPanel();
	private ScrollPanel assetScrollPanel = new ScrollPanel();
	private ScrollPanel fieldScrollPanel = new ScrollPanel();
	private Anchor expandBtn = new Anchor("Expand All");
	private Anchor collapseBtn = new Anchor("Collapse All");
	com.gwtext.client.widgets.Button okButton;
	com.gwtext.client.widgets.Button cancelButton;
	Panel tab = new Panel();
	
	private com.gwtext.client.widgets.TabPanel popupTabPanel = new com.gwtext.client.widgets.TabPanel();
	private Timer timer;
	private List<HandlerRegistration> currentHackHandlers = new ArrayList<HandlerRegistration>();
	private TreeSearcher srchBox = new TreeSearcher(wholeTree, new SearchBoxSelectionHandler(), new SrchBoxItemSelectableHandler());

	protected FieldSelector() {
		super(true);
		timer = new Timer() {
			public void run() {
				assetScrollPanel.setScrollPosition(currentPosition);
			}
		};
		 ResizableConfig config = new ResizableConfig();  
	        config.setHandles(Resizable.SOUTH_EAST);  
	  
	        final Resizable resizable = new Resizable(popupTabPanel, config);  
	        resizable.addListener(new ResizableListenerAdapter() {  
	            public void onResize(Resizable self, int width, int height) {  
	           
	                popupTabPanel.setWidth(width+"px"); 
	                assetScrollPanel.setWidth((width/2)-3+"px");
	                fieldScrollPanel.setWidth((width/2)-3+"px");
	            	popupTabPanel.setHeight(height+"px"); 
	        	    assetScrollPanel.setHeight(height - 123+"px");
	                fieldScrollPanel.setHeight(height - 135+"px");
	                
	                resizeGlass();
	                	                
	            }  
	        }); 
	        

		
		addCloseHandler();
		addSelectionHandler();
		addButtons();
		assetScrollPanel.setWidget(tree);
		fieldScrollPanel.setWidget(fieldTree);
		searchPanel.setWidth("100%");
		assetScrollPanel.setWidth("300px");
		fieldScrollPanel.setWidth("290px");
		assetScrollPanel.setHeight("237"+"px");
		fieldScrollPanel.setHeight("225"+"px");
		
		leftContainer.add(assetScrollPanel);
		expandPanel.setWidth("100%");
		expandPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
		
		ImageWidget dropDownImgCollapseRight=new ImageWidget("cms_title_ui/resources/images/child-collapseAll-normalState.png");
		dropDownImgCollapseRight.setStyleName("popup-right-collapse-all");
		
		dropDownImgCollapseRight.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {

				collapseAll(fieldTree);
			}
		});
		 
		ImageWidget dropDownImgExpandRight=new ImageWidget("cms_title_ui/resources/images/child-expandAll-normalState.png");
		dropDownImgExpandRight.setStyleName("popup-right-expand-all");
		dropDownImgExpandRight.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				expandAll(fieldTree);
				
			}
		});
		expandPanel.add(dropDownImgExpandRight);
		expandPanel.add(expandBtn);
		expandPanel.add(dropDownImgCollapseRight);
		expandPanel.add(collapseBtn);
		rightContainer.add(expandPanel);
		rightContainer.add(fieldScrollPanel);
	
		searchPanel.add(getControlWidget());
		fieldPanel.add(leftContainer);
		fieldPanel.add(rightContainer);
		mainPanel.add(searchPanel);
		mainPanel.add(fieldPanel);
		tab.setTitle("All");
		tab.add(mainPanel);
		popupTabPanel.setResizeTabs(true);
		popupTabPanel.setHeight(350);
		popupTabPanel.add(tab);
		popupTabPanel.setActiveTab(0);
		popupTabPanel.setWidth(600);
		popupTabPanel.setButtonAlign(Position.CENTER);
		popupTabPanel.addButton(okButton);
		popupTabPanel.addButton(cancelButton);
		popupTabPanel.setStyleName(STYLE_FIELD_SELECTOR, true);
		
		setGlassEnabled(true);
		setAutoHideEnabled(false);
		setWidget(popupTabPanel); // full tree view by default
	}
	
	private void resizeGlass() {
        // find the glass panel el which always lives one level down from body
		Element glassPanelEl = getChildElementByClass( Document.get().getBody(), "gwt-PopupPanelGlass" );
       
        
        if( glassPanelEl != null ) {
        	// get the new desired height... will only increase the size of the glass panel
        	int newHeiht = Math.max( Document.get().getScrollHeight(), Window.getClientHeight() );
        	glassPanelEl.getStyle().setHeight(newHeiht, Unit.PX);
        	
        	// get the new desired width... will only increase the size of the glass panel        	
        	int newWidth = Math.max( Document.get().getScrollWidth(), Window.getClientWidth() );
        	glassPanelEl.getStyle().setWidth(newWidth, Unit.PX);
        }

	}
	
	private Element getChildElementByClass( Element parent, String className ) {
		// get the first child of the parent
        Element childElement = parent.getFirstChildElement();
        
        // iterate over the children
        while ( childElement != null ) {
            // get all of the classes of the el
            List<String> classes = Arrays.asList( childElement.getClassName().toLowerCase().split(" ") );
            
            // return the el if it has the class name
            if( classes.contains( className.toLowerCase() ) ) {
            	return childElement;
            }
            
            // get next child of parent
            childElement = childElement.getNextSiblingElement();
        }
        
        // not found
        return null;
	}

	private void addSelectionHandler() {
		tree.addSelectionHandler(new SelectionHandler<TreeItem>() {
			@Override
			public void onSelection(SelectionEvent<TreeItem> event) {
				handleSelection(event);
				
			}

		});
		
	}

	private void addCloseHandler() {
		this.addCloseHandler(new CloseHandler<PopupPanel>() {
	      
	        public void onClose(CloseEvent<PopupPanel> event) { 
	        	
	        	if(event.isAutoClosed()) {
	        		//setSelectedItem(treeObject);
	        	}
	        }
	    });
		
	}

	private void addButtons() {
	
		okButton = new com.gwtext.client.widgets.Button("OK", new ButtonListenerAdapter() {
	        public void onClick(com.gwtext.client.widgets.Button button, EventObject e) {
	        	getHandler().onSelection(selectedItem);
				hide(false);
	        }
	    });
	cancelButton = new com.gwtext.client.widgets.Button("Cancel", new ButtonListenerAdapter() {
        public void onClick(com.gwtext.client.widgets.Button button, EventObject e) {
        	hide(true);
        }
    });
		

	}

	protected FieldSelector(List<TreeItem> items) {
		this();
		addItems(items);

	}

	/*
	 * this is to fix that bloody hack that moves the wheel back and forth
	 */
	private void addScrollHack() {
		for (HandlerRegistration r : currentHackHandlers) {
			r.removeHandler();
		}
		currentHackHandlers.clear();

		currentHackHandlers.add(tree.addMouseDownHandler(new MouseDownHandler() {
			@Override
			public void onMouseDown(MouseDownEvent event) {
				currentPosition = assetScrollPanel.getScrollPosition();
			}
		}));

		currentHackHandlers.add(tree.addMouseUpHandler(new MouseUpHandler() {
			@Override
			public void onMouseUp(MouseUpEvent event) {
				timer.schedule(5);
			}
		}));

	}

	private Widget getControlWidget() {
		return srchBox;
	}

	/**
	 * Show the specification in tree format from the root
	 * 
	 * @param x
	 * @param y
	 * @param xmlObj
	 */
	public void show(int x, int y, IFieldTreeObject treeObj, FieldSelectorHandler handler) {
		// Firstly select the item in the tree, but if no object then we don't
		// need to set the existing item
		this.setHandler(handler);
		showTree(x, y);

		addScrollHack();
		this.treeObject = treeObj;
		setSelectedItem(treeObj);
		
		resizeGlass();	// resize the glass when re-opened.
	}

	/**
	 * Only displays a subtree. It is reconstructed everytime so we might
	 * needadmin to eventually clean up our unused trees
	 * 
	 * @param row
	 * @param opType
	 * @param item
	 */
	public static FieldSelector getSubTree(TreeItem subitem) {
		FieldSelector fieldSelector = new FieldSelector();
		IFieldTreeObject treeObj = (IFieldTreeObject) subitem.getUserObject();
		TreeItem parentItem = new TreeItem(treeObj.getSimpleDisplayName());
		parentItem.setUserObject(treeObj);
		
		fieldSelector.tree.addItem(parentItem);
		fieldSelector.wholeTree.addItem(subitem);
	
		return fieldSelector;
	}

	public static void clearCache() {
		fieldSelectorMap.clear();
	}

	public static FieldSelector getTree(CriteriaType critType, UiCriteriaMode critMode) {
		FieldSelectorMapKey key = new FieldSelectorMapKey(critType, critMode);
		if (!fieldSelectorMap.containsKey(key)) {
			fieldSelectorMap.put(key, new FieldSelector(TreeCreator.getTreeItems(critType, critMode)));
		}
		return fieldSelectorMap.get(key);
	}

	public static void initialize(CriteriaType critType, UiCriteriaMode critMode) {
		FieldSelectorMapKey key = new FieldSelectorMapKey(critType, critMode);
		if (!fieldSelectorMap.containsKey(key)) {
			fieldSelectorMap.put(key, new FieldSelector(TreeCreator.getTreeItems(critType, critMode)));
		}
	}

	public static FieldSelector getTypedTree(CriteriaType critType, UiCriteriaMode critMode, UIDataType dataType) {
		return new FieldSelector(TypedTreeCreator.getTreeItems(critType, critMode, dataType, false));
	}

	public TreeItem findLicenseRoot(Tree tree) {
		Iterator<TreeItem> iterator = tree.treeItemIterator();
		while (iterator.hasNext()) {
			TreeItem item = iterator.next();

			IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
			if (findObj instanceof LicenseTreeObject) {

				return item;

			}

		}
		return null;
	}

	private void setSelectedItem(IFieldTreeObject treeObj) {
		TreeItem item = null;
		if (treeObj != null) {
			String assType = treeObj.getAssetType();
			String xpath = treeObj.getField();
			item = findItem(assType, xpath, wholeTree);
				if (item != null) {
					setProperSelectedItem(item);
				} else {
					// it is in the left tree
					item = findItem(assType, xpath, tree);
					tree.setSelectedItem(item, false);
					tree.ensureSelectedItemVisible();
					assetScrollPanel.ensureVisible(item);
				}
			}
		else {
			getHandler().onSelection(null);
			selectedItem = item;
		}

	
	}

	/*
	 * Show the tree widget relative to the widget
	 */
	private void showTree(final int x, final int y) {
		srchBox.reset();

		setPopupPositionAndShow(new PopupPanel.PositionCallback() {
			public void setPosition(int offsetWidth, int offsetHeight) {
				int height = Window.getClientHeight();
				int yOffset = 0;
				if (y + BOX_HEIGHT_INT > height)
					yOffset = BOX_HEIGHT_INT;
				setPopupPosition(x, y - yOffset);
			}
		});
	}

	private TreeItem findItem(String assetType, String xpath, Tree tree) {
		Iterator<TreeItem> iterator = tree.treeItemIterator();
		while (iterator.hasNext()) {
			TreeItem item = iterator.next();
			IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
			String fAssetType = findObj.getAssetType();
			String fXPath = findObj.getField();
			if (assetType.equals(fAssetType) && xpath.equals(fXPath)) {
				return item;
			}
		}
		return null;
	}

	@SuppressWarnings("deprecation")
	protected void addItems(List<TreeItem> items) {
		tree.clear();
		// here we need to separate between asset tree and field tree.
		for (TreeItem item : items) {
			IFieldTreeObject treeObj = (IFieldTreeObject) item.getUserObject();
			if (treeObj instanceof AssetTreeObject) {
				// only assets
				tree.addItem(addAssetTreeItems(item));

			} else if (treeObj instanceof LicenseTreeObject) {
				tree.addItem(addLicenseRootOnly(item));
			} else {// add all other list items
				tree.addItem(addAssetTreeItems(item));
			}

		}

		// add to temp whole tree that we will use to find subdirectories
		wholeTree.clear();
		for (TreeItem item : items) {
			wholeTree.addItem(item);


		}
		
		
	}


	

	private void handleSelection(SelectionEvent<TreeItem> event) {
		TreeItem item = event.getSelectedItem();
		IFieldTreeObject treeObj = (IFieldTreeObject) item.getUserObject();
		FieldSelectorHandler 
		handler = getHandler();
		if(handler instanceof RightFieldSelectionHandler) {
			if (getHandler().isSelectable(item)) {
				item.setSelected(true);
				selectedItem = item;
				setFieldTree(item, null);
			}
			else {
				item.setSelected(false);
				setFieldTree(item, null);
			}
		}
		
		else
		if (getHandler().isSelectable(item)) {
			item.setSelected(true);
			selectedItem = item;
			//getHandler().onSelection(item);
			// hide();
			setFieldTree(item, null);
		} else if (treeObj instanceof LicenseTreeObject) {
			setFieldTree(item, null);
			item.setSelected(false);
		} else {
			item.setSelected(false);
			setFieldTree(item, null);
		}

		
	}

	private TreeItem addLicenseRootOnly(TreeItem rootItem) {
		IFieldTreeObject treeObj = (IFieldTreeObject) rootItem.getUserObject();
		TreeItem item = new TreeItem(treeObj.getSimpleDisplayName());
		item.setUserObject(treeObj);
		
		return item;
	}

	private void addLicenseGroups(IFieldTreeObject treeObj, TreeItem item) {
		List<IFieldTreeObject> treeObjList = treeObj.getChildren();
		for (IFieldTreeObject treeO : treeObjList) {
			TreeItem child = new TreeItem(treeO.getSimpleDisplayName());
			item.addItem(child);
			child.setUserObject(treeO);
			// all children will go to field tree
		}

	}

	private TreeItem addAssetTreeItems(TreeItem rootItem) {
		IFieldTreeObject treeObj = (IFieldTreeObject) rootItem.getUserObject();
		
		TreeItem item = new TreeItem(treeObj.getSimpleDisplayName());
		item.setUserObject(treeObj);
		if (rootItem.getChildCount() > 0) {
			setStyleTreeItemBranch(item);
			if (treeObj.getChildren() != null & !treeObj.getChildren().isEmpty()) {
				addTreeChildren(treeObj, item);
			}
		} else {
			setStyleTreeItemLeaf(item);
		}
		return item;
	}
	private String addTreeItemChildren(TreeItem item) {
		// TODO Auto-generated method stub
		return null;
	}
	private void addTreeChildren(IFieldTreeObject treeObj, TreeItem item) {
		// TODO Auto-generated method stub
		List<IFieldTreeObject> treeObjList = treeObj.getChildren();
		for (IFieldTreeObject treeO : treeObjList) {

			if (treeO instanceof AssetTreeObject || treeO instanceof LicenseTreeObject) {
				TreeItem child = new TreeItem(treeO.getSimpleDisplayName());
				item.addItem(child);
				child.setUserObject(treeO);
				if (treeO.getChildren() != null & !treeO.getChildren().isEmpty()) {
					setStyleTreeItemBranch(child);
					addTreeChildren(treeO, child);					
				} else {
					setStyleTreeItemLeaf(child);
				}
			}

		}
	}

	private void addFieldTreeChildren(IFieldTreeObject treeObj, TreeItem item) {
		// TODO Auto-generated method stub
		List<IFieldTreeObject> treeObjList = treeObj.getChildren();
		for (IFieldTreeObject treeO : treeObjList) {
			TreeItem child = new TreeItem(treeO.getSimpleDisplayName());
			item.addItem(child);
			child.setUserObject(treeO);
			if (treeO.getChildren() != null & !treeO.getChildren().isEmpty()) {
				addFieldTreeChildren(treeO, child);
			}

		}
	}

	private void addFieldTreeFieldChildren(IFieldTreeObject treeObj, TreeItem item) {
		// TODO Auto-generated method stub
		List<IFieldTreeObject> treeObjList = treeObj.getChildren();
		for (IFieldTreeObject treeO : treeObjList) {

			TreeItem child = new TreeItem(treeO.getSimpleDisplayName());

			item.addItem(child);
			child.setUserObject(treeO);
			if (treeO.getChildren() != null & !treeO.getChildren().isEmpty()) {
				addFieldTreeChildren(treeO, child);
			}
		}

	}
//fieldTreeSelector
	@Override
	public void onSelection(SelectionEvent<TreeItem> event) {
		// expand the selected item and mark it as selected
		// second tree
		TreeItem item = event.getSelectedItem();
		IFieldTreeObject aObj = (IFieldTreeObject) item.getUserObject();
		if (getHandler().isSelectable(item)) {
			item.setSelected(true);
			if(aObj instanceof LicenseTreeObject) {
				TreeItem lItem = findLicenseRoot(tree);
				lItem.setSelected(true);
			}
			else {
				TreeItem parentItem = getAssetItem(item);
				parentItem.setSelected(true);
			}
			selectedItem = item;
			//getHandler().onSelection(item);
		}
	
			else {
				if(aObj instanceof LicenseTreeObject) {
					TreeItem lItem = findLicenseRoot(tree);
					lItem.setSelected(false);
				}
			item.setSelected(false);
		}
	}

	private void setFieldTree(TreeItem item, TreeItem selectedItem) {
		//fieldTree = new Tree();
		fieldTree.addSelectionHandler(this);
		fieldTree.clear();
		
		List<TreeItem> fieldRootItemList = new ArrayList<TreeItem>();
		IFieldTreeObject assetObj = (IFieldTreeObject) item.getUserObject();
		if (assetObj instanceof LicenseTreeObject) {
			// special case
			fieldRootItemList = findLicenseObjectChildren(assetObj.getDataType(), assetObj.getSimpleDisplayName());
		} else {
			String fAssetType = assetObj.getAssetType();
			String fXPath = assetObj.getField();
			fieldRootItemList = findChildren(fAssetType, fXPath);
		}

		for (TreeItem treeItem : fieldRootItemList) {
			IFieldTreeObject treeObj = (IFieldTreeObject) treeItem.getUserObject();
			TreeItem item2 = new TreeItem(treeObj.getSimpleDisplayName());
			item2.setUserObject(treeObj);
			fieldTree.addItem(item2);
			if (treeObj.getChildren() != null & !treeObj.getChildren().isEmpty() && treeItem.getChildCount() >0) {
					setStyleTreeItemBranch(item2);
					addFieldTreeFieldChildren(treeObj, item2, treeItem);
			
			} else {
				setStyleTreeItemLeaf(item2);
			}

		}
		if (selectedItem != null) {
			IFieldTreeObject selectedObj = (IFieldTreeObject) selectedItem.getUserObject();
			TreeItem foundSelectedItem = null;
	
			foundSelectedItem = findItem(selectedObj.getAssetType(), selectedObj.getField(), fieldTree);
		
			if (foundSelectedItem != null) {
				fieldScrollPanel.setWidget(fieldTree);
				fieldTree.setSelectedItem(foundSelectedItem, false);
				fieldTree.ensureSelectedItemVisible();
				fieldScrollPanel.ensureVisible(foundSelectedItem);

			}
		} else {
			fieldScrollPanel.setWidget(fieldTree);
		}

		expandBtn.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				expandAll(fieldTree);

			}
		});
		collapseBtn.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				collapseAll(fieldTree);

			}
		});

	}

	


	private void addFieldTreeFieldChildren(IFieldTreeObject treeObj, TreeItem item, TreeItem treeItem) {
		// TODO Auto-generated method stub
				if(treeItem.getChildCount() >0) {
					for(int i = 0; i<treeItem.getChildCount(); i++) {
						TreeItem itemChild = treeItem.getChild(i);
						IFieldTreeObject findObj = (IFieldTreeObject) itemChild.getUserObject();
						TreeItem child = new TreeItem(findObj.getSimpleDisplayName());
						child.setUserObject(findObj);
						item.addItem(child);
						if(itemChild.getChildCount() >0) {
						
								setStyleTreeItemBranch(child);
								addFieldTreeItemChildren(itemChild, child);
						
						} else {
							setStyleTreeItemLeaf(child);
						}
					}
				}

		
	}

	private void addFieldTreeItemChildren(TreeItem treeItem, TreeItem child2) {
		if(treeItem.getChildCount() >0) {
			for(int i = 0; i<treeItem.getChildCount(); i++) {
				TreeItem itemChild = treeItem.getChild(i);
				IFieldTreeObject obj = (IFieldTreeObject) itemChild.getUserObject();
				TreeItem child = new TreeItem(obj.getSimpleDisplayName());
				child.setUserObject(obj);
				child2.addItem(child);
				if(itemChild.getChildCount() >0) {
						setStyleTreeItemBranch(child);						
						addFieldTreeItemChildren(itemChild, child);

				
				} else {
					setStyleTreeItemLeaf(child);					
				}
			}
		}
		
		
	}

	private List<TreeItem> findLicenseObjectChildren(UIDataType rootDataType, String rootSimpleDisplayName) {
		List<TreeItem> itemList = new ArrayList<TreeItem>();
		TreeItem rootItem = null;
		Iterator<TreeItem> iterator = this.wholeTree.treeItemIterator();
		while (iterator.hasNext()) {
			TreeItem item = iterator.next();
			IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
			UIDataType dataType = findObj.getDataType();
			String simpleDisplayName = findObj.getSimpleDisplayName();
			if (dataType.value().equalsIgnoreCase(rootDataType.value()) && simpleDisplayName.equalsIgnoreCase(rootSimpleDisplayName)) {
				rootItem = item;
				break;
			}

		}
		// simply add all the children of the root
		if (rootItem != null) {
			if (rootItem.getChildCount() > 0) {

				for (int i = 0; i < rootItem.getChildCount(); i++) {
					TreeItem child = (rootItem.getChild(i));
					itemList.add(child);

				}
			}

		}
		return itemList;
	}

	private List<TreeItem> findChildren(String fAssetType, String fXPath) {
		List<TreeItem> itemList = new ArrayList<TreeItem>();
		TreeItem rootItem = null;
		Iterator<TreeItem> iterator = this.wholeTree.treeItemIterator();
		while (iterator.hasNext()) {
			TreeItem item = iterator.next();
			IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
			String assetType = findObj.getAssetType();
			String xpath = findObj.getField();
			if (assetType.equals(fAssetType) && xpath.equals(fXPath)) {
				rootItem = item;
				break;
			}
		}
		if (rootItem != null && rootItem.getChildCount() > 0) {
			for (int i = 0; i < rootItem.getChildCount(); i++) {
				TreeItem child = (rootItem.getChild(i));
				IFieldTreeObject findObj = (IFieldTreeObject) child.getUserObject();
				if (!(findObj instanceof AssetTreeObject)) {
					itemList.add(child);
				}
			}
		}
		return itemList;
	}

	private FieldSelectorHandler getHandler() {
		return handler;
	}

	private void setHandler(FieldSelectorHandler handler) {
		this.handler = handler;
	}

	private class SearchBoxSelectionHandler implements SelectionHandler<TreeItem> {
		@Override
		public void onSelection(SelectionEvent<TreeItem> event) {
			TreeItem item = event.getSelectedItem();
			if (getHandler().isSelectable(item)) {
				setProperSelectedItem(item);
				srchBox.setFocus();
			} else {
				item.setSelected(false);
			}

		}

	}

	private class SrchBoxItemSelectableHandler implements ItemSelectableHandler {

		@Override
		public boolean isSelectable(TreeItem item) {
			if (item == null)
				return false;
			return getHandler().isSelectable(item);
		}

	}


	protected void collapseAll(Tree tree) {
		for (int i = 0; i < tree.getItemCount(); i++) {
			TreeItem item = tree.getItem(i);
			if (item.getState() && !collapseHelper(item))
				item.setState(false, false);
		}
	}

	private boolean collapseHelper(TreeItem parent) {
		boolean result = false;
		for (int i = 0; i < parent.getChildCount(); i++) {
			TreeItem item = parent.getChild(i);
			boolean childResult = collapseHelper(item);
			if (childResult || item.isSelected()) {
				result = true;
			} else 
			if (item.getState() && !childResult) {
				item.setState(false, false);
			} 
		}
		return result;
	}

	protected void expandAll(Tree tree) {
		for (int i = 0; i < tree.getItemCount(); i++) {
			TreeItem item = tree.getItem(i);
			if (!item.getState())
				item.setState(true, false);
			 	expandHelper(item);
		}

	}

	private void expandHelper(TreeItem parent) {
		
		for (int i = 0; i < parent.getChildCount(); i++) {
			TreeItem item = parent.getChild(i);
			item.setState(true, false);
			expandHelper(item);
			
		}
		
	}

	

	private boolean matchedLicense(TreeItem item) {
		IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
		if (findObj instanceof LicenseTreeObject) {
			return true;
		}
		return false;
	}

	private TreeItem findPMMItem(String path, Tree tree) {
		Iterator<TreeItem> iterator = tree.treeItemIterator();
		while (iterator.hasNext()) {
			TreeItem item = iterator.next();

			IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
			if (findObj instanceof PMMTitleTreeObject) {
				if (findObj.getField().equalsIgnoreCase(path)) {
					return item;
				}
			}

		}
		return null;
	}

	private boolean matchedPMM(TreeItem item) {
		IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
		if (findObj instanceof PMMTitleTreeObject) {
			return true;
		}
		return false;
	}

	private TreeItem getAssetItem(TreeItem fieldItem) {
		IFieldTreeObject fieldObj = (IFieldTreeObject) fieldItem.getUserObject();
		String assetType = fieldObj.getAssetType();
		// has to be asset object , not file
		IFieldTreeObject assetObj = getParentAsset(assetType);
		TreeItem assetItem = findItem(assetObj.getAssetType(), assetObj.getField(), tree);

		return assetItem;
	}

	private IFieldTreeObject getParentAsset(String assetType) {
		// if assetType is file, find the parent asset;
		if (assetType.toUpperCase().endsWith("/FILE")) {
			assetType = assetType.substring(0, (assetType.indexOf("/FILE")));
		}
		if (tree != null) {
			Iterator<TreeItem> iterator = tree.treeItemIterator();
			while (iterator.hasNext()) {
				TreeItem item = iterator.next();
				IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();

				if (assetType.equals(findObj.getAssetType())) {
					return findObj;
				}
			}
		}
		return null;
	}

	private boolean matchedFieldTree(TreeItem item) {

		IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
		String fAssetType = findObj.getAssetType();
		String fXPath = findObj.getField();
		TreeItem foundItem = findItem(fAssetType, fXPath, wholeTree);
		if (foundItem != null) {
			return true;
		}
		return false;

	}

	private boolean matchedTree(TreeItem item) {
		IFieldTreeObject findObj = (IFieldTreeObject) item.getUserObject();
		String fAssetType = findObj.getAssetType();
		String fXPath = findObj.getField();
		TreeItem foundItem = findItem(fAssetType, fXPath, tree);
		if (foundItem != null) {
			return true;
		}
		return false;
	}

	public void setProperSelectedItem(TreeItem item) {
		if (matchedLicense(item)) {

			TreeItem licenseRoot = findLicenseRoot(tree);
			tree.setSelectedItem(licenseRoot, false);
			tree.ensureSelectedItemVisible();
			setFieldTree(licenseRoot, item);
			selectedItem = item;
			//getHandler().onSelection(item);
			assetScrollPanel.ensureVisible(licenseRoot);
			
		}else
		if (matchedPMM(item)) {
			IFieldTreeObject assetObj = (IFieldTreeObject) item.getUserObject();
			TreeItem assetItem = findPMMItem(((PMMTitleTreeObject) assetObj).getField(), tree);
			tree.setSelectedItem(assetItem, false);
			tree.ensureSelectedItemVisible();
			setFieldTree(assetItem, null);
			selectedItem = item;
			//getHandler().onSelection(item);
			assetScrollPanel.ensureVisible(assetItem);
		}
		// find which tree it matches
		else if (matchedTree(item)) {

			IFieldTreeObject assetObj = (IFieldTreeObject) item.getUserObject();
			TreeItem assetItem = findItem(assetObj.getAssetType(), assetObj.getField(), tree);
			tree.setSelectedItem(assetItem, false);
			tree.ensureSelectedItemVisible();
			setFieldTree(assetItem, null);
			selectedItem = item;
			//getHandler().onSelection(item);
			assetScrollPanel.ensureVisible(assetItem);

		} else if (matchedFieldTree(item)) {
			// find asset of of matched field - highlight
			TreeItem assetItem = getAssetItem(item);
			tree.setSelectedItem(assetItem, false);
			tree.ensureSelectedItemVisible();

			// create fieldTree for that asset. highlight corresponding
			// item.
			setFieldTree(assetItem, item);
			selectedItem = item;
			//getHandler().onSelection(item);

		}

	}
	
	private void setStyleTreeItemBranch( TreeItem item ) {
		Element content = getTreeItemContentElement( item );
		if( content != null ) {
			content.addClassName(STYLE_IS_BRANCH);
			content.removeClassName(STYLE_IS_LEAF);
		}
	}
	private void setStyleTreeItemLeaf( TreeItem item ) {
		Element content = getTreeItemContentElement( item );
		if( content != null ) {
			content.addClassName(STYLE_IS_LEAF);
			content.removeClassName(STYLE_IS_BRANCH);
		}
	}
	private Element getTreeItemContentElement( TreeItem item ) {
		Element firstLevel = item.getElement().getFirstChildElement();
		String role = firstLevel.getAttribute("role");
		if( role != null && role.equalsIgnoreCase("treeitem") ) {
			return firstLevel;
		} else {
			try {
				Element content = firstLevel.getFirstChildElement().getFirstChildElement().getNextSiblingElement().getFirstChildElement();
				String role2 = content.getAttribute("role");
				if( role2 != null && role2.equalsIgnoreCase("treeitem") ) {
					return content;
				} else {
					return null;
				}
			} catch ( Exception e ) {
				return null;
			}
		}

	}
	
}
