package com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;

public class AssetFieldTreeObject implements IsSerializable, IFieldTreeObject {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	protected static Map<String, Map<String, String>> fieldOptions;

	private String field;
	
	private UIDataType dataType;

	private String assetPath;

	private String extendedDisplayName;
	private String displayName = "";
	private String simpleDisplayName;

	private String complexType;

	private List<IFieldTreeObject> children;
	
	public static void setFieldOptions( Map<String, Map<String, String>> contentClassOptions) {
		AssetFieldTreeObject.fieldOptions = contentClassOptions;
	}
	
	public static Map<String, Map<String, String>> getFieldOptions() {
		return fieldOptions;
	}

	/**
	 * @param field
	 * @param dataType
	 * @param assetPath
	 * @param displayName
	 */
	public AssetFieldTreeObject(String field, UIDataType dataType,
			String assetPath, String displayName, String complexType, String extendedDisplayName) {
		super();
		this.field = field;
		this.dataType = dataType;
		this.assetPath = assetPath;
		this.displayName = displayName;
		this.extendedDisplayName = extendedDisplayName;
		if(displayName != null) {
			int beginIndex  = displayName.lastIndexOf(".")+1;
			if(beginIndex > 0)
				this.simpleDisplayName = displayName.substring(beginIndex);
		}
		this.complexType = complexType;
	}

	/**
	 * 
	 */
	public AssetFieldTreeObject() {
		super();
	}

	public UIDataType getDataType() {
		return dataType;
	}

	public String getField() {
		return field;
	}

	@Override
	public String getAssetType() {
		return assetPath;
	}

	public String getFullDisplayName() {
		return displayName;
	}
	
	@Override
	public String getSimpleDisplayName() {
		return simpleDisplayName;
	}

	public boolean equals(Object obj) {
		if (obj instanceof AssetFieldTreeObject) {
			AssetFieldTreeObject otherVal = (AssetFieldTreeObject) obj;
			boolean assetTypeEqual = otherVal.getAssetType().equals(
					getAssetType());
			boolean xpathEqual = otherVal.getField().equals(getField());
			return assetTypeEqual && xpathEqual;
		}
		return false;
	}

	public String toString() {
		return getAssetType() + "|" + getField();
	}

	public UIFieldType getFieldType() {
		return UIFieldType.ASSET;
	}

	@Override
	public Collection<UIValueOption> getSuggestedValues() {
		if(fieldOptions== null) {
			Window.alert("AssetFieldOptionProvider isn't being loaded");
			return new ArrayList<UIValueOption>();
		}
		if(!fieldOptions.containsKey(getField())) {
			return null;
		}
		List<UIValueOption> uiOptions = new ArrayList<UIValueOption>();
		for(Entry<String, String> option : fieldOptions.get(getField()).entrySet()) {
			uiOptions.add(new UIValueOption(option.getValue(), option.getKey()));
		}
		return uiOptions;
	}

	@Override
	public boolean supportsActions() {
		return true;
	}

	@Override
	public boolean childSupportsActions() {
		return !getAssetType().startsWith("SERIES");
	}

	@Override
	public boolean supportsOther() {
		return true;
	}

	public boolean supportsRHSField() {
		return !getDataType().equals(UIDataType.COMPLEX);
	}

	@Override
	public boolean hasSuggestedValues() {
		return fieldOptions != null && fieldOptions.get(getField()) != null;
	}

	@Override
	public boolean supportsCriteriaType(CriteriaType critType, UiCriteriaMode critMode) {
		if(getField().equals("/Fields/CustomFields"))
			return false;
		return commonSupportLogic(critType, critMode);
	}

	private boolean commonSupportLogic(CriteriaType critType, UiCriteriaMode critMode) {
		if (critType.equals(CriteriaType.BASIC_METADATA))
			return ((getAssetType().startsWith("PACKAGE") && critMode.equals(UiCriteriaMode.EPISODE)) 
					|| (getAssetType().startsWith("SERIES") && critMode.equals(UiCriteriaMode.SERIES)));

		if(critMode.equals(UiCriteriaMode.SERIES) && getAssetType().startsWith("PACKAGE"))
			return false;
		if (getAssetType().startsWith("SERIES")
				&& critMode.equals(UiCriteriaMode.EPISODE)
				&& (critType.equals(CriteriaType.SEARCH_CONDITION_LHS) || critType.equals(CriteriaType.ACTION_RHS)))
			return false;
		if (critType.equals(CriteriaType.CONDITION_RHS)
				|| critType.equals(CriteriaType.CONDITION_RHS_LICRULE)) {
			return supportsRHSField();
		} else if (critType.equals(CriteriaType.NORM_ACTION_LHS) || critType.equals(CriteriaType.MSO_ACTION_LHS)) {
			return supportsActions();
		} else if (critType.equals(CriteriaType.ACTION_RHS)) {
			return !critMode.equals(UiCriteriaMode.SERIES) && supportsActions()
					&& !getAssetType().startsWith("SERIES");
		}
		return true;
	}
	@Override
	public boolean supportsSuggestValues() {
		boolean supportedDataType = getDataType().equals(UIDataType.INTEGER)
				|| getDataType().equals(UIDataType.FLOAT)
				|| getDataType().equals(UIDataType.STRING);
		return supportedDataType && hasSuggestedValues();
	}

	@Override
	public boolean supportsMatched() {
		return true;
	}

	@Override
	public boolean childSupportsCriteriaType(CriteriaType critType,
			UiCriteriaMode critMode) {
		return commonSupportLogic(critType, critMode);
	}

	@Override
	public String getComplexType() {
		return complexType;
	}

	public List<IFieldTreeObject> getChildren() {
		if(children == null)
			children = new ArrayList<IFieldTreeObject>();
		return children;
	}

	public void addChild(IFieldTreeObject child) {
		if(children == null)
			children = new ArrayList<IFieldTreeObject>();
		this.children.add(child);
	}

	public void setChildren(List<IFieldTreeObject> children) {
		this.children = children;
	}

	@Override
	public String getExtendedDisplayName() {
		return extendedDisplayName;
	}

	@Override
	public int hashCode() {
		return (assetPath+field).hashCode();
	}
}