package com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;

public class AssetFileTreeObject implements IsSerializable, IFieldTreeObject {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String assetPath;
	private List<IFieldTreeObject> children;
	private String extendedDisplayName;

	/**
	 * 
	 */
	public AssetFileTreeObject() {
		super();
	}

	public AssetFileTreeObject(String assetPath, List<IFieldTreeObject> children, String extendedDisplayName) {
		this.assetPath = assetPath;
		this.children = children;
		this.extendedDisplayName = extendedDisplayName;
	}
	
	@Override
	public UIDataType getDataType() {
		// assets don't have a data type
		return UIDataType.COMPLEX;
	}

	@Override
	public UIFieldType getFieldType() {
		return UIFieldType.ASSET;
	}

	@Override
	public String getFullDisplayName() {
		return "File";
	}

	@Override
	public String getSimpleDisplayName() {
		return "File";
	}

	@Override
	public List<UIValueOption> getSuggestedValues() {
		return new ArrayList<UIValueOption>();
	}

	@Override
	public boolean hasSuggestedValues() {
		return false;
	}

	@Override
	public boolean supportsActions() {
		return false;
	}
	
	@Override
	public boolean childSupportsActions() {
		return true;
	}

	@Override
	public boolean supportsOther() {
		return true;
	}

	public boolean supportsRHSField() {
		return false;
	}

	@Override
	public String getAssetType() {
		return assetPath;
	}

	@Override
	public String getField() {
		return "";
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof AssetTreeObject) {
			return ((AssetTreeObject) obj).getAssetType()
					.equals(getAssetType());
		}
		return false;
	}

	@Override
	public boolean supportsCriteriaType(CriteriaType critType, UiCriteriaMode critMode) {
		if (critType.equals(CriteriaType.BASIC_METADATA))
			return ((getAssetType().startsWith("PACKAGE") && critMode.equals(UiCriteriaMode.EPISODE)) 
					|| (getAssetType().startsWith("SERIES") && critMode.equals(UiCriteriaMode.SERIES)));

		if(critMode.equals(UiCriteriaMode.SERIES) && getAssetType().startsWith("PACKAGE"))
			return false;
		if (getAssetType().startsWith("SERIES")
				&& critMode.equals(UiCriteriaMode.EPISODE)
				&& critType.equals(CriteriaType.SEARCH_CONDITION_LHS))
			return false;
		if (critType.equals(CriteriaType.CONDITION_RHS)
				|| critType.equals(CriteriaType.CONDITION_RHS_LICRULE)) {
			return supportsRHSField();
		} else if (critType.equals(CriteriaType.NORM_ACTION_LHS) || critType.equals(CriteriaType.MSO_ACTION_LHS)) {
			return supportsActions();
		} else if (critType.equals(CriteriaType.ACTION_RHS)) {
			return false;
		}
		return true;
	}

	@Override
	public boolean supportsSuggestValues() {
		return false;
	}

	@Override
	public boolean supportsMatched() {
		return true;
	}

	@Override
	public boolean childSupportsCriteriaType(CriteriaType critType,
			UiCriteriaMode critMode) {
		if(critType.equals(CriteriaType.NORM_ACTION_LHS) || critType.equals(CriteriaType.MSO_ACTION_LHS) || critType.equals(CriteriaType.ACTION_RHS))
			return childSupportsActions();
		return supportsCriteriaType(critType, critMode);
	}

	@Override
	public String getComplexType() {
		return null;
	}

	@Override
	public List<IFieldTreeObject> getChildren() {
		return children;
	}
	
	@Override
	public void setChildren(List<IFieldTreeObject> children) {
		this.children = children;
	}

	@Override
	public String getExtendedDisplayName() {
		return extendedDisplayName;
	}

	@Override
	public int hashCode() {
		return assetPath.hashCode();
	}


}
