package com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.IAssetTypeWFileProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.IAssetTypeWFileProviderAsync;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;

public class AssetTreeObject implements IsSerializable, IFieldTreeObject {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Set<String> AssetTypesWithFile;
	private String displayName;
	private String assetPath;
	private List<IFieldTreeObject> children;

	private String complexType;
	private String extendedDisplayName;

	
	/**
	 * 
	 */
	public AssetTreeObject() {
		super();
	}

	/**
	 * @param displayName
	 * @param assetPath
	 */
	public AssetTreeObject(String displayName, String assetPath, String complexType, String extendedDisplayName) {
		super();
		this.displayName = displayName;
		this.assetPath = assetPath;
		this.complexType = complexType;
		this.extendedDisplayName = extendedDisplayName;
	}

	public static void initialize(final AsyncCallback<Void> callback) {
		//already got it
		if(AssetTypesWithFile != null)
			callback.onSuccess(null);

		//make call to server
		IAssetTypeWFileProviderAsync service = GWT.create(IAssetTypeWFileProvider.class);
		service.getAssetTypeWFile(new AsyncCallback<Set<String>>() {

			@Override
			public void onFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			@Override
			public void onSuccess(Set<String> result) {
				AssetTypesWithFile = result;
				callback.onSuccess(null);
			}
			
		});
		
	}

	public static boolean isInitialized() {
		return AssetTypesWithFile != null;
	}

	@Override
	public UIDataType getDataType() {
		// assets don't have a data type
		return UIDataType.COMPLEX;
	}

	@Override
	public UIFieldType getFieldType() {
		return UIFieldType.ASSET;
	}

	@Override
	public String getFullDisplayName() {
		return displayName;
	}

	@Override
	public String getSimpleDisplayName() {
		return displayName;
	}

	@Override
	public List<UIValueOption> getSuggestedValues() {
		return new ArrayList<UIValueOption>();
	}

	@Override
	public boolean hasSuggestedValues() {
		return false;
	}

	@Override
	public boolean supportsActions() {
		return assetPath.contains("/");
	}

	@Override
	public boolean childSupportsActions() {
		return true;
	}

	@Override
	public boolean supportsOther() {
		return true;
	}

	public boolean supportsRHSField() {
		return true;
	}

	@Override
	public String getAssetType() {
		return assetPath;
	}

	@Override
	public String getField() {
		return "";
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof AssetTreeObject) {
			return ((AssetTreeObject) obj).getAssetType()
					.equals(getAssetType());
		}
		return false;
	}

	@Override
	public boolean supportsCriteriaType(CriteriaType critType, UiCriteriaMode critMode) {
		if (critType.equals(CriteriaType.BASIC_METADATA))
			return ((getAssetType().startsWith("PACKAGE") && critMode.equals(UiCriteriaMode.EPISODE)) 
					|| (getAssetType().startsWith("SERIES") && critMode.equals(UiCriteriaMode.SERIES)));
		if(critMode.equals(UiCriteriaMode.SERIES) && getAssetType().startsWith("PACKAGE"))
			return false;
		if (getAssetType().startsWith("SERIES")
				&& critMode.equals(UiCriteriaMode.EPISODE)
				&& (critType.equals(CriteriaType.SEARCH_CONDITION_LHS) || critType.equals(CriteriaType.SEARCH_CONDITION_LHS)))
			return false;
		if (critType.equals(CriteriaType.CONDITION_RHS)
				|| critType.equals(CriteriaType.CONDITION_RHS_LICRULE)) {
			return supportsRHSField();
		} else if (critType.equals(CriteriaType.NORM_ACTION_LHS) || critType.equals(CriteriaType.MSO_ACTION_LHS)) {
			return supportsActions();
		} else if (critType.equals(CriteriaType.ACTION_RHS)) {
			return supportsActions();
		}
		return true;
	}

	@Override
	public boolean childSupportsCriteriaType(CriteriaType critType,
			UiCriteriaMode critMode) {
		if (critType.equals(CriteriaType.NORM_ACTION_LHS) || critType.equals(CriteriaType.MSO_ACTION_LHS) || critType.equals(CriteriaType.ACTION_RHS)) {
			return childSupportsActions();
		}
		return supportsCriteriaType(critType, critMode);
	}


	@Override
	public boolean supportsSuggestValues() {
		return false;
	}
	
	public boolean supportsFiles() {
		int beginIndex = assetPath.lastIndexOf("/")+1;
		return AssetTypesWithFile.contains(assetPath.substring(beginIndex));
	}

	@Override
	public boolean supportsMatched() {
		return true;
	}

	@Override
	public String getComplexType() {
		return complexType;
	}

	public List<IFieldTreeObject> getChildren() {
		if(children == null) {
			children = new ArrayList<IFieldTreeObject>();
		}
		return children;
	}

	public void addChild(IFieldTreeObject child) {
		if(children == null)
			children = new ArrayList<IFieldTreeObject>();
		this.children.add(child);
	}

	public void setChildren(List<IFieldTreeObject> children) {
		this.children = children;
	}
	
	public AssetTreeObject cloneWithoutChildAssetFields() {
		AssetTreeObject clone = new AssetTreeObject(getFullDisplayName(), assetPath, complexType, extendedDisplayName);
		List<IFieldTreeObject> children = new ArrayList<IFieldTreeObject>();
		for(IFieldTreeObject child : this.getChildren()) {
			if(child instanceof AssetFieldTreeObject)
				children.add(child);
			else if(child instanceof AssetTreeObject)
				children.add(new AssetTreeObject(child.getFullDisplayName(), child.getAssetType(), child.getComplexType(), child.getExtendedDisplayName()));
		}
		clone.setChildren(children);
		return clone;
	}

	public AssetTreeObject cloneWithoutChildAsset() {
		AssetTreeObject clone = new AssetTreeObject(getFullDisplayName(), assetPath, complexType, extendedDisplayName);
		List<IFieldTreeObject> children = new ArrayList<IFieldTreeObject>();
		for(IFieldTreeObject child : this.children) {
			if(child instanceof AssetFieldTreeObject)
				children.add(child);
		}
		clone.setChildren(children);
		return clone;
	}

	@Override
	public String getExtendedDisplayName() {
		return extendedDisplayName;
	}

	@Override
	public int hashCode() {
		return assetPath.hashCode();
	}
}
