package com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;

public interface IFieldTreeObject extends Serializable {
	
	/**
	 * Returns the simple display name to display within the tree
	 * @return
	 */
	String getSimpleDisplayName();
	
	/**
	 * Returns the full display name to be displayed field box
	 * @return
	 */
	String getFullDisplayName();
	
	String getExtendedDisplayName();

	/**
	 * Returns a list of string suggested values
	 * @return
	 */
	Collection<UIValueOption> getSuggestedValues();
	
	/**
	 * Returns the field type
	 * @return
	 */
	UIFieldType getFieldType();
	
	String getComplexType();
	
	/** 
	 * Returns the data type of the field
	 * @return
	 */
	UIDataType getDataType();
	
	/**
	 * Returns true if this XMLTreeObject supports actions
	 * @return
	 */
	boolean supportsActions();

	boolean childSupportsActions();

	/**
	 * Returns true if this 
	 * @return
	 */
	boolean hasSuggestedValues();
	
	/**
	 * Returns true if other is allowed for this field.
	 * @return
	 */
	boolean supportsOther();
	
	/**
	 * returns true if this field supports suggested values.
	 * @return
	 */
	boolean supportsSuggestValues();
	
	boolean supportsCriteriaType(CriteriaType critType, UiCriteriaMode critMode);

	boolean childSupportsCriteriaType(CriteriaType critType, UiCriteriaMode critMode);
	
	boolean supportsMatched();

	String getAssetType();

	String getField();
	
	List<IFieldTreeObject> getChildren();

	void setChildren(List<IFieldTreeObject> children);
}
