package com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;

public class LicenseTreeObject implements IsSerializable, IFieldTreeObject {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Collection<UIValueOption> suggestedValues;
	private String field;
	private String displayName;
	private UIDataType dataType;

	private List<IFieldTreeObject> children;

	private String extendDisplayName;

	public LicenseTreeObject() {
		
	}

	/**
	 * @param fieldDefinition
	 * @param field
	 * @param displayName
	 * @param dataType
	 */
	public LicenseTreeObject(String field, String displayName, UIDataType dataType, String extendDisplayName) {
		super();
		this.field = field;
		this.displayName = displayName;
		this.dataType = dataType;
		this.extendDisplayName = extendDisplayName;
		suggestedValues = new ArrayList<UIValueOption>(0);
	}
	
	/**
	 * @param fieldDefinition
	 * @param field
	 * @param displayName
	 * @param dataType
	 */
	public LicenseTreeObject(String field, String displayName, UIDataType dataType, Collection<UIValueOption> suggestedValues, String extendDisplayName) {
		this(field, displayName, dataType, extendDisplayName);
		this.suggestedValues = suggestedValues;
	}

	@Override
	public String getSimpleDisplayName() {
		return displayName;
	}

	@Override
	public String getFullDisplayName() {
		return "Licensing." + displayName;
	}

	@Override
	public Collection<UIValueOption> getSuggestedValues() {
		return suggestedValues;
	}

	@Override
	public UIFieldType getFieldType() {
		return UIFieldType.LICENSE;
	}

	@Override
	public UIDataType getDataType() {
		return dataType;
	}

	@Override
	public boolean supportsActions() {
		return !dataType.equals(UIDataType.COMPLEX);
	}
	
	@Override
	public boolean childSupportsActions() {
		return true;
	}

	@Override
	public boolean hasSuggestedValues() {
		return !suggestedValues.isEmpty();
	}

	@Override
	public boolean supportsOther() {
		return true;
	}

	@Override
	public boolean supportsSuggestValues() {
		boolean supportedDataType = getDataType().equals(UIDataType.INTEGER)
				|| getDataType().equals(UIDataType.FLOAT)
				|| getDataType().equals(UIDataType.STRING);
		return supportedDataType && hasSuggestedValues();
	}

	public boolean supportsRHSField() {
		return true;
	}

	@Override
	public boolean supportsCriteriaType(CriteriaType critType,
			UiCriteriaMode critMode) {
		if(critMode.equals(UiCriteriaMode.SERIES) || dataType.equals(UIDataType.COMPLEX))
			return false;
		return childSupportsCriteriaType(critType, critMode);
	}

	@Override
	public String getAssetType() {
		return "LICENSE";
	}

	@Override
	public String getField() {
		return field;
	}

	@Override
	public boolean supportsMatched() {
		return false;
	}

	@Override
	public boolean childSupportsCriteriaType(CriteriaType critType,
			UiCriteriaMode critMode) {
		if(critMode.equals(UiCriteriaMode.SERIES))
			return false;
		switch (critType) {
		case CONDITION_RHS:
			return true;
		case RULE_CONDITION_LHS:
			return true;
		case SEARCH_CONDITION_LHS:
			return false;
		case NORM_ACTION_LHS:
			return true;
		case MSO_ACTION_LHS:
			return true;
		case ACTION_RHS:
			return false;
		default:
			return false;
		}
	}

	@Override
	public String getComplexType() {
		return null;
	}

	public List<IFieldTreeObject> getChildren() {
		if(children == null)
			children = new ArrayList<IFieldTreeObject>();
		return children;
	}

	public void addChild(IFieldTreeObject child) {
		if(children == null)
			children = new ArrayList<IFieldTreeObject>();
		this.children.add(child);
	}

	@Override
	public void setChildren(List<IFieldTreeObject> children) {
		this.children = children;
	}

	@Override
	public String getExtendedDisplayName() {
		return "Licensing." + extendDisplayName;
	}
}
