package com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import java.util.Collection;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;

public class MatchedItemTreeObj implements IsSerializable, IMIFieldTreeObject {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private IFieldTreeObject userObject;
	private IFieldTreeObject parent;
	private TitleConstants myConstants = (TitleConstants) GWT
			.create(TitleConstants.class);

	
	/**
	 * 
	 */
	public MatchedItemTreeObj() {
		super();
	}

	public MatchedItemTreeObj(IFieldTreeObject userObject,
			IFieldTreeObject parent) {
		this.userObject = userObject;
		setParent(parent);
	}

	/**
	 * Sets the root XmlTreeObject of this matched item.
	 * 
	 * @param parent
	 */
	public void setParent(IFieldTreeObject parent) {
		this.parent = parent;
	}

	/**
	 * Gets the root XmlTreeObject of this matched item.
	 * 
	 * @return
	 */
	public IFieldTreeObject getParent() {
		return parent;
	}

	@Override
	public String getFullDisplayName() {
		if(getAssetType().startsWith("NEW/"))
			 return "New"+ "." + userObject.getFullDisplayName();
		return myConstants.matched() + "." + userObject.getFullDisplayName();
	}

	public IFieldTreeObject getUserObject() {
		return userObject;
	}

	@Override
	public UIDataType getDataType() {
		return userObject.getDataType();
	}

	@Override
	public UIFieldType getFieldType() {
		return userObject.getFieldType();
	}

	@Override
	public String getSimpleDisplayName() {
		if (getAssetType().startsWith("NEW/")
				&& (userObject instanceof AssetTreeObject && parent
						.getAssetType().equals(userObject.getAssetType())))
			return "New"+ "." + userObject.getSimpleDisplayName();
		return userObject.getSimpleDisplayName();
	}

	@Override
	public Collection<UIValueOption> getSuggestedValues() {
		return userObject.getSuggestedValues();
	}

	@Override
	public boolean supportsActions() {
		return userObject.supportsActions();
	}
	
	@Override
	public boolean childSupportsActions() {
		return userObject.childSupportsActions();
	}

	@Override
	public boolean hasSuggestedValues() {
		return userObject.hasSuggestedValues();
	}

	@Override
	public boolean supportsOther() {
		return false;
	}

	public boolean supportsRHSField() {
		return false;
	}

	@Override
	public String getAssetType() {
		if (parent.getAssetType().startsWith("NEW/")
				&& !userObject.getAssetType().startsWith("NEW/"))
			return "NEW/"+userObject.getAssetType();
		return userObject.getAssetType();
	}

	@Override
	public String getField() {
		return userObject.getField();
	}

	@Override
	public boolean supportsCriteriaType(CriteriaType critType, UiCriteriaMode critMode) {
		return userObject.supportsCriteriaType(critType, critMode);
	}

	@Override
	public boolean supportsSuggestValues() {
		return userObject.supportsSuggestValues();
	}

	@Override
	public boolean equals(Object obj) {
		if(obj == null)
			return false;
		if(obj instanceof MatchedItemTreeObj) {
			MatchedItemTreeObj other = (MatchedItemTreeObj) obj;
			return other.getParent().equals(getParent()) && other.getUserObject().equals(userObject);
		}
		//I know this looks weird but it is legacy and I don't want to break anything.
		return userObject.equals(obj);
	}

	@Override
	public boolean supportsMatched() {
		return true;
	}

	@Override
	public boolean childSupportsCriteriaType(CriteriaType critType,
			UiCriteriaMode critMode) {
		return supportsCriteriaType(critType, critMode);
	}

	@Override
	public String getComplexType() {
		return userObject.getComplexType();
	}

	@Override
	public List<IFieldTreeObject> getChildren() {
		return userObject.getChildren();
	}

	@Override
	public String getExtendedDisplayName() {
		// TODO Auto-generated method stub
		if(getAssetType().startsWith("NEW/"))
			 return "New." +userObject.getExtendedDisplayName();
		return myConstants.matched() + "." + userObject.getExtendedDisplayName();
	}

	@Override
	public void setChildren(List<IFieldTreeObject> children) {
		userObject.setChildren(children);
	}


}