package com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UIMasterTitleDistributionStatus;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITitleStatus;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleClientBundle;

public class PMMFieldProvider {

	public static final String TITLE_ID = "id";
	public static final String TITLE_STATUS = "status";
	public static final String CONTENT_CLASS = "contentClassId";
	public static final String DISTRIBUTION_STATUS = "distributionStatus";
	public static final String OFFER = "Offer";
	public static final String CATEGORY = "Category";


	private static TitleClientBundle bundle = new TitleClientBundle();
	private static TitleConstants titleConstants = GWT.create(TitleConstants.class);
	private static PMMTitleTreeObject contentClass;

	private static List<UIValueOption> contentClasses;
	public static void setContentClasses(List<UIValueOption> options) {
		contentClasses = options;
		if(contentClass == null) {
			contentClass = new PMMTitleTreeObject(CONTENT_CLASS, titleConstants.contentClass(),
					UIDataType.INTEGER, contentClasses, false);
		} else {
			contentClass.setSuggestedValues(options);
		}
	}

	/*
	 * Method to return Offer Content Class on UI
	 * It will be used in In Place Search
	 * */
    public static String getOfferContentClass() {
      String offerId = String.valueOf(4); /*By default offerCC should be 4*/
      for (UIValueOption cc: contentClasses){
        if (cc.getName().equalsIgnoreCase(OFFER)){
          offerId = cc.getValue();
          break;
        }
      }
      return offerId;
    }
    
    /*
     * Method to return Category Content Class on UI
     * It will be used in In Place Search
     * */
    public static String getCategoryContentClass() {
      String categoryId = String.valueOf(3); /*By default Category should be 3*/
      for (UIValueOption cc: contentClasses){
        if (cc.getName().equalsIgnoreCase(CATEGORY)){
          categoryId = cc.getValue();
          break;
        }
      }
      return categoryId;
    }
	
	/**
	 * 
	 */
	public PMMFieldProvider() {
		super();
	}


	public static PMMTitleTreeObject getPMMTreeObjects(String field) {
		if(field.equals(TITLE_ID)) {
			return new PMMTitleTreeObject(TITLE_ID, titleConstants.TitleId(), UIDataType.INTEGER);
		}
		if(field.equals(TITLE_STATUS)) {
			return new PMMTitleTreeObject(TITLE_STATUS, titleConstants.titleStatus(),UIDataType.STRING, 
					getTitleStatusOptions(), false);
		}
		if(field.equals(CONTENT_CLASS)) {
			return contentClass;
		}
		// aggregated distribution status
		if(field.equals(DISTRIBUTION_STATUS))
			return new PMMTitleTreeObject(DISTRIBUTION_STATUS, titleConstants.distributionStatus(), 
					UIDataType.STRING, getTitleDistributionStatus(), false);
		
		throw new IllegalArgumentException("Unkown field: "+ field);
	}

	public static List<PMMTitleTreeObject> getPMMTreeObjects(UiCriteriaMode critMode) {
		List<PMMTitleTreeObject> result = new ArrayList<PMMTitleTreeObject>();
		result.add(new PMMTitleTreeObject(TITLE_ID, titleConstants.TitleId(), UIDataType.INTEGER));
		result.add(new PMMTitleTreeObject(TITLE_STATUS, titleConstants.titleStatus(), UIDataType.STRING, 
				getTitleStatusOptions(), false));
		if(!critMode.equals(UiCriteriaMode.SERIES) && contentClass != null) {
			result.add(contentClass);
		}
		// aggregated distribution status
		if(!critMode.equals(UiCriteriaMode.SERIES))
			result.add(new PMMTitleTreeObject(DISTRIBUTION_STATUS, titleConstants.distributionStatus(), 
					UIDataType.STRING, getTitleDistributionStatus(), false));
				
		return result;
	}
	
	public static List<PMMTitleTreeObject> getPMMTreeObjects() {
		List<PMMTitleTreeObject> result = new ArrayList<PMMTitleTreeObject>();
		result.add(new PMMTitleTreeObject(TITLE_ID, titleConstants.TitleId(), UIDataType.INTEGER));
		result.add(new PMMTitleTreeObject(TITLE_STATUS, titleConstants.titleStatus(), UIDataType.STRING, 
				getTitleStatusOptions(), false));
		result.add(contentClass);
		return result;
	}

	public static List<UiBasicSearchField> getBasicSearchFields(UiCriteriaMode critMode) {
		List<UiBasicSearchField> result = new ArrayList<UiBasicSearchField>();
		UiBasicSearchField titleId = new UiBasicSearchField("PMM_TITLE",
				TITLE_ID, titleConstants.TitleId(), UIDataType.INTEGER,
				BaseOperator.EQUAL, UIFieldType.PMM_TITLE);
		UiBasicSearchField titleStatus = new UiBasicSearchField("PMM_TITLE",
				TITLE_STATUS, titleConstants.titleStatus(),
				UIDataType.STRING, getTitleStatusOptions(), false,
				BaseOperator.EQUAL, UIFieldType.PMM_TITLE);
		UiBasicSearchField contentClass = new UiBasicSearchField("PMM_TITLE",
				CONTENT_CLASS, titleConstants.contentClass(), UIDataType.INTEGER,
				contentClasses, false, BaseOperator.EQUAL,
				UIFieldType.PMM_TITLE);
		UiBasicSearchField titleDistStatus = new UiBasicSearchField("PMM_TITLE",
				DISTRIBUTION_STATUS, titleConstants.distributionStatus(),
				UIDataType.STRING, getTitleDistributionStatus(), false,
				BaseOperator.EQUAL, UIFieldType.PMM_TITLE);
		
		result.add(titleId);
		result.add(titleStatus);
		if(!critMode.equals(UiCriteriaMode.SERIES)) {
			result.add(contentClass);
			result.add(titleDistStatus);
		}
		return result;
	}

	public static List<UIValueOption> getTitleStatusOptions() {
		List<UIValueOption> options = new ArrayList<UIValueOption>();
		options.add(new UIValueOption(bundle.getStatusName(UITitleStatus.DRAFT), "DRAFT"));
		options.add(new UIValueOption(bundle.getStatusName(UITitleStatus.COMMITTED), "COMMITTED"));
		options.add(new UIValueOption(bundle.getStatusName(UITitleStatus.READY), "READY"));
		options.add(new UIValueOption(bundle.getStatusName(UITitleStatus.RETIRED), "RETIRED"));
		return options;
	}
	/***
	 * 
	 * @return list of aggregated distribution status
	 */
	private static List<UIValueOption> getTitleDistributionStatus(){
		List<UIValueOption> options = new ArrayList<UIValueOption>();
		List<UIMasterTitleDistributionStatus> values = new ArrayList<UIMasterTitleDistributionStatus>(Arrays.asList(UIMasterTitleDistributionStatus.values()));
		for (int i = 0; i < values.size(); i++){
			options.add(new UIValueOption(values.get(i).toString(), values.get(i).toString()));
		}
		return options;
	}
}
