package com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;

public class PMMTitleTreeObject implements IsSerializable, IFieldTreeObject {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private List<UIValueOption> suggestedValues;
	private String displayName;
	private String path;
	private UIDataType dataType;
	private boolean supportsOther;

	/**
	 * 
	 */
	public PMMTitleTreeObject() {
		super();
	}

	public PMMTitleTreeObject(String path, String displayName,
			UIDataType dataType) {
		this.path = path;
		this.displayName = displayName;
		this.dataType = dataType;
		suggestedValues = new ArrayList<UIValueOption>();
		supportsOther = false;
	}

	public PMMTitleTreeObject(String path, String displayName,
			UIDataType dataType, List<UIValueOption> suggestedValues,
			boolean supportsOther) {
		this.path = path;
		this.displayName = displayName;
		this.dataType = dataType;
		this.supportsOther = supportsOther;
		this.suggestedValues = suggestedValues;
	}

	@Override
	public UIDataType getDataType() {
		return dataType;
	}

	@Override
	public UIFieldType getFieldType() {
		return UIFieldType.PMM_TITLE;
	}

	@Override
	public String getFullDisplayName() {
		return displayName;
	}

	@Override
	public String getSimpleDisplayName() {
		return displayName;
	}

	@Override
	public List<UIValueOption> getSuggestedValues() {
		return suggestedValues;
	}
	
	public void setSuggestedValues(List<UIValueOption> suggestedValues) {
		this.suggestedValues = suggestedValues;
	}

	@Override
	public boolean supportsActions() {
		// PMM Title objects never support actions
		return false;
	}
	
	@Override
	public boolean childSupportsActions() {
		return false;
	}

	@Override
	public boolean supportsOther() {
		return supportsOther;
	}

	@Override
	public boolean supportsSuggestValues() {
		boolean supportedDataType = getDataType().equals(UIDataType.INTEGER)
				|| getDataType().equals(UIDataType.FLOAT)
				|| getDataType().equals(UIDataType.STRING);
		return supportedDataType && getSuggestedValues().size() > 0;
	}

	public boolean supportsRHSField() {
		// PMM Title objects never support RHS field
		return false;
	}

	@Override
	public boolean hasSuggestedValues() {
		return suggestedValues.size() > 0;
	}

	@Override
	public String getAssetType() {
		// TODO not sure if this is what we want
		return "PMM_TITLE";
	}

	@Override
	public String getField() {
		return path;
	}

	@Override
	public boolean supportsCriteriaType(CriteriaType critType, UiCriteriaMode critMode) {
		return critType.equals(CriteriaType.SEARCH_CONDITION_LHS)
				|| critType.equals(CriteriaType.RULE_CONDITION_LHS)
				|| critType.equals(CriteriaType.RULE_CONDITION_LHS_LICRULE);
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof PMMTitleTreeObject) {
			return ((PMMTitleTreeObject) obj).getField().equals(getField());
		}
		return false;
	}

	@Override
	public boolean supportsMatched() {
		return false;
	}

	@Override
	public boolean childSupportsCriteriaType(CriteriaType critType,
			UiCriteriaMode critMode) {
		return supportsCriteriaType(critType, critMode);
	}

	@Override
	public String getComplexType() {
		return null;
	}

	@Override
	public List<IFieldTreeObject> getChildren() {
		return null;
	}

	@Override
	public String getExtendedDisplayName() {
		return getFullDisplayName();
	}

	@Override
	public void setChildren(List<IFieldTreeObject> children) {
		
	}

}
