package com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import com.google.gwt.user.client.rpc.IsSerializable;


public enum UIDataType implements IsSerializable {
	INTEGER("integer"),
	FLOAT("float"),
	BOOLEAN("boolean"),
	STRING("string"),
	DATE("date"),
	TIME("time"),
	COMPLEX("complex");
	
	private String name;

	UIDataType(String name) {
		this.name = name;
	}
	
	public String getDataTypeName() {
		return name;
	}
	
	public String value() {
		return name;
	}
	
	public static UIDataType fromValue(String name) {
	     for (UIDataType c: UIDataType.values()) {
	            if (c.value().equals(name)) {
	                return c;
	            }
	        }
	     
	     throw new IllegalArgumentException(name);  
	}
}
