package com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import java.io.Serializable;
import java.util.List;

import com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;

public class UiBasicSearchField implements Serializable {
	private static final long serialVersionUID = 1L;

	private String assetType;
	private String xpath;
	private String displayName;
	private UIDataType datatype;
	private List<UIValueOption> suggestedValues;
	private BaseOperator defaultOperator;
	private UIFieldType fieldType;
	private boolean complex;

	private boolean supportsOther;

	

	/**
	 * Don't use this constructor. It is here for GWT.
	 */
	public UiBasicSearchField() {

	}

	/**
	 * Creates a new BasicSearchField.
	 * 
	 * @param assetType
	 *            The assetType for this field.
	 * @param xpath
	 *            The xpath for this field.
	 * @param displayName
	 *            The displayName for this field.
	 * @param datatype
	 *            The data type of the field.
	 *            list.
	 */
	public UiBasicSearchField(String assetType, String xpath, String displayName,
			UIDataType datatype, BaseOperator operator, UIFieldType fieldType) {
		super();
		this.assetType = assetType;
		this.xpath = xpath;
		this.displayName = displayName;
		this.datatype = datatype;
		this.defaultOperator = operator;
		this.fieldType = fieldType;
	}
	
	public UiBasicSearchField(String assetType, String xpath, String displayName,
			UIDataType datatype, List<UIValueOption> suggestedValues, boolean supportsOther, BaseOperator operator, UIFieldType fieldType) {
		super();
		this.assetType = assetType;
		this.xpath = xpath;
		this.displayName = displayName;
		this.datatype = datatype;
		this.suggestedValues = suggestedValues;
		this.defaultOperator = operator;
		this.fieldType = fieldType;
		this.setSupportsOther(supportsOther);
	}

	/**
	 * @return The assetType for this field.
	 */
	public String getAssetType() {
		return assetType;
	}

	/**
	 * @return The xpath for this field.
	 */
	public String getXpath() {
		return xpath;
	}

	/**
	 * @return The displayName for this field.
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * @return The data type of the field.
	 */
	public UIDataType getDatatype() {
		return datatype;
	}

	/**
	 * @return The suggested values. If none exist an empty list is returned.
	 */
	public List<UIValueOption> getSuggestedValues() {
		return suggestedValues;
	}

	/**
	 * 
	 * @return The operator to use when there are no suggested values.
	 */
	public BaseOperator getDefaultOperator() {
		return defaultOperator;
	}

	public UIFieldType getFieldType() {
		// TODO Auto-generated method stub
		return fieldType;
	}

	@Override
	public boolean equals(Object obj) {
		if(obj instanceof UiBasicSearchField) {
			UiBasicSearchField other = (UiBasicSearchField) obj;
			return other.getAssetType().equals(assetType) && other.getXpath().equals(xpath);
		}
		return false;
		
	}
	public boolean isComplex() {
		return complex;
	}

	public void setComplex(boolean complex) {
		this.complex = complex;
	}

	public boolean supportsOther() {
		return supportsOther;
	}

	public void setSupportsOther(boolean supportsOther) {
		this.supportsOther = supportsOther;
	}
}
