package com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;

public class UiSubscriptionFields implements IFieldTreeObject {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private UIDataType dataType;
	private String displayName;
	private String identifier;
	private UiSubscriptionProfile subscriptionProfile;

	private String complexType;

	/**
	 * provided for GWT only. Should not be used.
	 */
	public UiSubscriptionFields() {
		super();
	}

	/**
	 * @param dataType
	 * @param displayName
	 * @param identifier
	 */
	public UiSubscriptionFields(UIDataType dataType, String displayName,
			String identifier, UiSubscriptionProfile subscriptionProfile, String complexType) {
		super();
		this.dataType = dataType;
		this.displayName = displayName;
		this.identifier = identifier;
		this.subscriptionProfile = subscriptionProfile;
		this.complexType = complexType;
	}

	@Override
	public String getSimpleDisplayName() {
		return displayName;
	}

	@Override
	public String getFullDisplayName() {
		return subscriptionProfile.getFullDisplayName()+"."+displayName;
	}

	@Override
	public Collection<UIValueOption> getSuggestedValues() {
		return new ArrayList<UIValueOption>(0);
	}

	@Override
	public UIFieldType getFieldType() {
		return UIFieldType.ENHANCEMENT;
	}

	@Override
	public UIDataType getDataType() {
		return dataType;
	}

	@Override
	public boolean supportsActions() {
		return true;
	}

	@Override
	public boolean childSupportsActions() {
		return true;
	}

	@Override
	public boolean hasSuggestedValues() {
		return false;
	}

	@Override
	public boolean supportsOther() {
		return false;
	}

	@Override
	public boolean supportsSuggestValues() {
		return false;
	}

	@Override
	public boolean supportsCriteriaType(CriteriaType critType,
			UiCriteriaMode critMode) {
		return critType.equals(CriteriaType.NORM_ACTION_LHS);
	}

	@Override
	public boolean supportsMatched() {
		return false;
	}

	@Override
	public String getAssetType() {
		return subscriptionProfile.getProfileId().toString();
	}

	@Override
	public String getField() {
		return identifier;
	}
	
	public UiSubscriptionProfile getSubscriptionProfile() {
		return subscriptionProfile;
	}

	@Override
	public boolean childSupportsCriteriaType(CriteriaType critType,
			UiCriteriaMode critMode) {
		return supportsCriteriaType(critType, critMode);
	}

	@Override
	public String getComplexType() {
		return complexType;
	}

	@Override
	public List<IFieldTreeObject> getChildren() {
		return null;
	}

	@Override
	public String getExtendedDisplayName() {
		return getFullDisplayName();
	}

	@Override
	public void setChildren(List<IFieldTreeObject> children) {
		
	}

}
