package com.tandbergtv.cms.portal.ui.title.client.criteria;

import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.LicenseTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.PMMFieldProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UiSubscriptionFields;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UiSubscriptionProfile;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;

public class FieldTreeCreator {

	public static IFieldTreeObject getFieldTreeObject(UIFieldType fieldType,
			String assetPath, String field, String displayName,
			UIDataType dataType, String comlexType, String extendedDisplayName) {
		switch(fieldType) {
		case ASSET:
			if(field == null || field.isEmpty())
				return new AssetTreeObject(displayName, assetPath, comlexType, extendedDisplayName);
			return new AssetFieldTreeObject(field, dataType, assetPath, displayName, comlexType, extendedDisplayName);
		case LICENSE:
			return new LicenseTreeObject(field, displayName, dataType, extendedDisplayName);
		case PMM_TITLE:
			return PMMFieldProvider.getPMMTreeObjects(field);
		case ENHANCEMENT:
			String[] split = displayName.split("[.]");
			Long profileId = Long.parseLong(assetPath);
			return new UiSubscriptionFields(dataType, split[1],
					field, new UiSubscriptionProfile(split[0], profileId), comlexType);
		}
		return null;
	}
}
