package com.tandbergtv.cms.portal.ui.title.client.criteria;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.model.search.TitleFilterOperator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ToggleButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * Predicate list is really nothing more than a container. It is responsible for
 * drawing all its crap
 * 
 * @author rchu
 * 
 */
public class PredicateList extends PredicateRowBase {
	private static final String BRACKET_STYLE = "bracket";
	private static final String PAD_PREDICATE_LIST_STYLE = "pad-predicate-list";
	private TitleFilterOperator listOperator;
	private LabelWidget label;
	private FlexTable container;
	private SimplePanel panel = new SimplePanel();
	private int maxLevels = 2;
	private ToggleButtonWidget tg;
	/**
	 * Default constructor
	 */
	public PredicateList(CriteriaListingPanel parentContainer, int maxLevels) {
		super(parentContainer);
		setMaxLevels(maxLevels);
		container = createContainer();
		panel.setWidget(container);
		add(panel);
	}
	
	/**
	 * Default constructor
	 */
	public PredicateList(PredicateList parentList) {
		super(parentList.root);
		setMaxLevels(parentList.maxLevels);
		setParentList(parentList);
		container = createContainer();
		panel.setWidget(container);
		add(panel);
		panel.addStyleName(PAD_PREDICATE_LIST_STYLE);
	}

	/*
	 * creates a container which has the brackets and the text format of the
	 * operator. this is added as a child row
	 */
	private FlexTable createContainer() {
		// create label and add to container
		label = new LabelWidget();
		tg = new ToggleButtonWidget("AND","OR");
		setOperator(TitleFilterOperator.AND);
		label.setStyleName("bracket-label");
		VerticalContainer labelContainer = new VerticalContainer();
		tg.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				//switch the operator
				if(listOperator.equals(TitleFilterOperator.AND))
					setOperator(TitleFilterOperator.OR);
				else
					setOperator(TitleFilterOperator.AND);
			}
		});
		labelContainer.add(tg);
		// create table which has the bracket on the left and children on the
		// right column
		FlexTable tableContainer = new FlexTable();
		tableContainer.setWidget(0, 0, tg);
		tableContainer.getCellFormatter().setStyleName(0, 0, BRACKET_STYLE);
		VerticalPanel rightSide = new VerticalPanel();
		rightSide.add(getChildrenPanel());
		rightSide.add(buildButtonPanel());
		tableContainer.setWidget(0, 1, rightSide);
		return tableContainer;
	}

	/**
	 * get the list operator, just a number 0 == and, 1 == OR.
	 * 
	 * @return
	 */
	public TitleFilterOperator getOperator() {
		return this.listOperator;
	}

	/**
	 * get the list operator, just a number 0 == and, 1 == OR.
	 * 
	 * @return
	 */
	public void setOperator(TitleFilterOperator op) {
		this.listOperator = op;
		if(this.listOperator.equals(TitleFilterOperator.AND)) {
			this.label.setText(myConstants.and());
			this.label.setTitle(myConstants.andTitle());
			tg.setDown(false);
		} else {
			this.label.setText(myConstants.or());
			this.label.setTitle(myConstants.orTitle());
			tg.setDown(true);
		}
	}

	/**
	 * Determines if the treeObject is in the this list. Doesn't look at
	 * children of a Predicate Row (eval child field rows).
	 * 
	 * @param treeObject
	 * @return
	 */
	public boolean contains(IFieldTreeObject treeObject) {
		return predicateRowsWithTreeObject(treeObject) > 0;
	}

	/**
	 * Returns the number of predicate rows that have that particular tree
	 * object selected.
	 * 
	 * @param treeObject
	 * @return
	 */
	public int predicateRowsWithTreeObject(IFieldTreeObject treeObject) {
		int count = 0;
		for (Widget w : getChildrenPanel()) {
			PredicateRowBase row = (PredicateRowBase) w;
			if (row instanceof PredicateList) {
				count += ((PredicateList) row)
						.predicateRowsWithTreeObject(treeObject);
			} else {
				PredicateRow predRow = (PredicateRow) row;
				if (treeObject != null
						&& treeObject.equals((predRow).getLhsTreeObject()))
					count++;
			}
		}
		return count;
	}

	/**
	 * Sets the AND/OR operator visible
	 * @param visible
	 */
	public void setOperatorVisible(boolean visible) {
		if(visible)
			container.getCellFormatter().setStyleName(0, 0, BRACKET_STYLE);
		else
			container.getCellFormatter().removeStyleName(0, 0, BRACKET_STYLE);
		label.setVisible(visible);
	}

	/**
	 * Builds the button panel for add criterion and add complex criterion.
	 * @return
	 */
	private Widget buildButtonPanel() {
		HorizontalPanel panel = new HorizontalPanel();
		panel.addStyleName(StyleNames.STYLE_CMS_BUTTON_CONTAINER);
		panel.add(getAddCriterionButton());
		if(getLevel() < maxLevels) {
			panel.add(getAddComplexButton());
		}
		return panel;
	}

	/**
	 * Returns the level of this list. For example the root would be 1.
	 * @return
	 */
	private int getLevel() {
		int i = 1;
		PredicateRowBase node = parentList;

		while (node != null) {
			i++;
			node = node.getParentList();
		}
		return i;
	}

	/**
	 * Creates a add complex criteria button.
	 * @return
	 */
	private Button getAddComplexButton() {
		Button button = new Button("Add Group");
		button.setTitle(myConstants.addComplexCriterion());
		button.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
		button.addStyleName(StyleNames.STYLE_EB_BTN);
		button.addStyleName(StyleNames.STYLE_ADD_GROUP_BUTTON_ICON);		
		button.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				// create two new rows and attach them to new list
				PredicateRow row1 = new PredicateRow(root);
				PredicateRow row2 = new PredicateRow(root);
				PredicateList list = new PredicateList(PredicateList.this);
				list.addChildRow(row1);
				list.addChildRow(row2);
				//by default I assume the operator should be inverted from its parent list
				list.setOperator(getOperator().invert());
				addChildRow(list);
			}
		});
		return button;
	}
	
	private Button getAddCriterionButton() {
		Button button = new Button("Add Row");
		button.setTitle(myConstants.addCriterion());
		button.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
		button.addStyleName(StyleNames.STYLE_EB_BTN);
		button.addStyleName(StyleNames.STYLE_ADD_ROW_BUTTON_ICON);
		button.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				addChildRow(new PredicateRow(root));
			}
		});
		return button;
	}

	/**
	 * sets this list equal to the new root.
	 * @param newRoot
	 */
	public void reroot(PredicateList newRoot) {
		setOperator(newRoot.getOperator());
		setChildrenPanel(newRoot.getChildrenPanel());

		VerticalPanel rightSide = new VerticalPanel();
		rightSide.add(getChildrenPanel());
		rightSide.add(buildButtonPanel());
		container.setWidget(0, 1, rightSide);

		for(Widget w : getChildrenPanel()) {
			// TODO if it is a list deal with it (don't worry this won't happen
			// right now)
			((PredicateRowBase)w).setParentList(this);
		}
	}
	
	/**
	 * Removes the item provided from the childrenPanel.
	 * @param item
	 */
	@Override
	public void removeItem(PredicateRowBase item) {
		super.removeItem(item);
		
		if (parentList == null && getChildrenPanel().getWidgetCount() == 1
				&& getChildrenPanel().getWidget(0) instanceof PredicateList) {
			//popup single child list.
			reroot((PredicateList)getChildrenPanel().getWidget(0));
		}

		if(getChildrenPanel().getWidgetCount() == 0 && parentList != null) {
			//deal with empty list 
			parentList.removeItem(this);
		} else if(getChildrenPanel().getWidgetCount() == 0) {
			//deal with empty root.
			PredicateRow pr = new PredicateRow(root);
			addChildRow(pr);
		}
	}

	/**
	 * 
	 * @param maxLevels
	 *            the maxLevels to set
	 */
	public void setMaxLevels(int maxLevels) {
		this.maxLevels = maxLevels;
	}

	/**
	 * @return the maxLevels
	 */
	public int getMaxLevels() {
		return maxLevels;
	}
}
