package com.tandbergtv.cms.portal.ui.title.client.criteria;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.TitleMessages;
import com.tandbergtv.cms.portal.ui.title.client.TitleStyleNames;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.RHSValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.RHSWidgetFactory;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.SimpleRHSValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueTextBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.StringValidator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIParamType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RhsType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperatorFull;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperatorLimited;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterConditionNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterRHSFieldNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterValueNode;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ToggleButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;


/**
 * A UI predicate row
 * 
 * @author dweiner
 * 
 */
public class PredicateRow extends PredicateRowBase {
	private TitleMessages myMessages = (TitleMessages) GWT.create(TitleMessages.class);

	private static final TitleConstants myConstants = (TitleConstants) GWT.create(TitleConstants.class);
	private static final String PREDICATE_LABEL_STYLE = "predicate-label";
	private static int switchRhsCounter = 0;

	private BaseOperator operatorProvider;
	private ListBoxWidget<BaseOperator> operatorList;
	private TextBox lhsFldTxtBox;
	private TextBox rhsFldTxtBox;
	private RHSValueWidget dataValue;
	private SimplePanel rhsValuePanel = new SimplePanel();
	private FieldSelector lhsFieldSelector;
	private FieldSelector rhsFieldSelector;
	private VerticalPanel switchRhs = new VerticalPanel();
	private RadioButton rhsField = new RadioButton("switchRhs" + switchRhsCounter, myConstants.field());
	private RadioButton rhsValue = new RadioButton("switchRhs" + switchRhsCounter, myConstants.value());
	private IFieldTreeObject treeObject;
	private IFieldTreeObject evalChild;
	private CheckBox notChkBox;

	private Button addRow;

	private IFieldTreeObject treeObjectRhs;

	private ToggleButtonWidget tg;
	private static String DELETE_GROUP_BUTTON_STYLE="delete-group-button";
	
	/**
	 * Predicate row with root node of containers specification
	 * 
	 * @param parentContainer
	 */
	public PredicateRow(CriteriaListingPanel parentContainer) {
		super(parentContainer);
		setOperatorProvider(parentContainer.getOperatorProvider());
		putUiTogther();
		switchRhsCounter++;
		addHandlers();
	}

	public PredicateRow(CriteriaListingPanel parentContainer, UITitleFilterConditionNode predicateNode) {
		super(parentContainer);
		setOperatorProvider(parentContainer.getOperatorProvider());
		putUiTogther();
		switchRhsCounter++;
		setPredicate(predicateNode);
		addHandlers();

	}

	/**
	 * Predicate row of a sub tree item. Specifically, evaluate child fields
	 * 
	 * @param parentContainer
	 * @param treeObj
	 */
	public PredicateRow(CriteriaListingPanel parentContainer, IFieldTreeObject treeObj) {
		this(parentContainer);
		if (treeObj instanceof AssetTreeObject && treeObj.getChildren().size() > 0)
			this.evalChild = ((AssetTreeObject) treeObj).cloneWithoutChildAsset();
		else
			this.evalChild = treeObj;
		// Set the search operator for eval child field.
		setOperatorProvider(new RulesOperatorLimited());
		addHandlers();
	}

	/**
	 * Predicate row of a sub tree item. Specifically, evaluate child fields
	 * 
	 * @param parentContainer
	 * @param treeObj
	 */
	public PredicateRow(CriteriaListingPanel parentContainer, IFieldTreeObject treeObj, UITitleFilterConditionNode predicateNode) {
		this(parentContainer);
		if (treeObj instanceof AssetTreeObject && treeObj.getChildren().size() > 0)
			this.evalChild = ((AssetTreeObject) treeObj).cloneWithoutChildAsset();
		else
			this.evalChild = treeObj;
		// Set the search operator for eval child field.
		setOperatorProvider(new RulesOperatorLimited());
		setPredicate(predicateNode);
		addHandlers();
	}

	private void addHandlers() {
		lhsFldTxtBox.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {

				if (canChangePredicateRow()) {
					showLhsFieldSelector();
				}
			}
		});

		rhsFldTxtBox.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				showRhsFieldSelector();
			}
		});
		rhsField.addClickHandler(new RhsSwitchHandler());
		rhsValue.addClickHandler(new RhsSwitchHandler());
	}

	/**
	 * Filter the operator list according to the data type
	 * 
	 * @param dataType
	 */
	private void filterOperatorList(IFieldTreeObject obj) {
		BaseOperator selectedItem = operatorList.getSelectedItem();
		// new List Contains Selected Item
		boolean newListContainsSI = false;
		operatorList.clear();

		BaseOperator sop = getOperatorProvider();
		List<BaseOperator> operators = sop.getOperators(obj);
		for (BaseOperator operator : operators) {
			String strItem = operator.toString();
			operatorList.addItem(myConstants.getString(strItem), operator);

			if (selectedItem != null && operator.equals(selectedItem)) {
				newListContainsSI = true;
			}
		}

		if (newListContainsSI) {
			operatorList.setSelectedItem(selectedItem);
		}
		resetDataValue(dataValue.getValues());
	}

	public void putUiTogther() {
		lhsFldTxtBox = new TextBox();
		rhsFldTxtBox = new TextBox();
		/*
		 * give the data value a string default so it looks pretty. The real one
		 * will be loaded when they select the operator
		 */
		dataValue = new SimpleRHSValueWidget(new ValueTextBox(new StringValidator()));
		rhsValuePanel.setWidget(dataValue);
		operatorList = createOperatorList();
		operatorList.addChangeHandler(new OperatorListChangeHandler());

		notChkBox = new CheckBox();
		notChkBox.setText(myConstants.not());
		notChkBox.addStyleName("small-txt");
		tg = new ToggleButtonWidget("Is","Not");
		tg.addStyleDependentName("SearchToggle");
		tg.addClickHandler(new ClickHandler() {
			@SuppressWarnings("deprecation")
			@Override
			
			public void onClick(ClickEvent event) {
				if(notChkBox.isChecked()){
					notChkBox.setChecked(false);
					tg.setDown(false);
				}else{
					notChkBox.setChecked(true);
					tg.setDown(true);
				}
			}
		});
		Button btnDelete = createRemoveButton();

		lhsFldTxtBox.setReadOnly(true);
		lhsFldTxtBox.addStyleName("black-txt");
		lhsFldTxtBox.addStyleName("small-txt");
		lhsFldTxtBox.setVisibleLength(35);

		rhsFldTxtBox.setReadOnly(true);
		rhsFldTxtBox.addStyleName("black-txt");
		rhsFldTxtBox.addStyleName("small-txt");
		rhsFldTxtBox.setVisibleLength(35);

		HorizontalPanel horPanel = new HorizontalPanel();
		horPanel.setSpacing(3);

		SimplePanel chkBoxContainer = new SimplePanel();
		chkBoxContainer.setWidget(notChkBox);
		chkBoxContainer.setWidget(tg);
		chkBoxContainer.addStyleName(PREDICATE_LABEL_STYLE);
		horPanel.add(chkBoxContainer);

		horPanel.setCellVerticalAlignment(chkBoxContainer, ALIGN_TOP);
		horPanel.add(lhsFldTxtBox);
		horPanel.setCellVerticalAlignment(lhsFldTxtBox, ALIGN_TOP);
		horPanel.add(operatorList);
		horPanel.setCellVerticalAlignment(operatorList, ALIGN_TOP);
		horPanel.add(switchRhs);
		horPanel.add(rhsValuePanel);
		horPanel.setCellVerticalAlignment(rhsValuePanel, ALIGN_TOP);

		horPanel.add(btnDelete);
		horPanel.setCellVerticalAlignment(btnDelete, ALIGN_TOP);

		treeObject = null;

		add(horPanel);

		/*
		 * add a container for the children for eval child fields this isn't for
		 * sub criteria or sibling critiria it is for eval child field only.
		 */
		add(this.createContainer());
		// default don't show this bugger
	}

	private void showLhsFieldSelector() {
		int x = lhsFldTxtBox.getAbsoluteLeft();
		int y = lhsFldTxtBox.getAbsoluteTop();
		if (lhsFieldSelector == null && evalChild != null) {
			TreeItem childTree = TreeCreator.convertToTreeItem(evalChild, root.getLhsCriteriaType(), root.getCriteriaMode());
			lhsFieldSelector = FieldSelector.getSubTree(childTree);
		} else if (lhsFieldSelector == null) {
			lhsFieldSelector = FieldSelector.getTree(root.getLhsCriteriaType(), root.getCriteriaMode());
		}
		lhsFieldSelector.show(x, y, treeObject, getLhsSelectHandler());
	}

	private void showRhsFieldSelector() {
		int x = rhsFldTxtBox.getAbsoluteLeft();
		int y = rhsFldTxtBox.getAbsoluteTop();
		if (rhsFieldSelector == null)
			rhsFieldSelector = FieldSelector.getTypedTree(root.getRhsCriteriaType(), root.getCriteriaMode(), treeObject.getDataType());
		rhsFieldSelector.show(x, y, treeObjectRhs, getRhsSelectHandler());
	}

	private void resetDataValue(List<String> values) {
		if (treeObject == null)
			return;

		BaseOperator operator = operatorList.getSelectedItem();
		if (operator.allowRhsField() && operatorProvider instanceof RulesOperatorLimited) {
			switchRhs.add(rhsField);
			switchRhs.add(rhsValue);
			rhsValue.setValue(true);
		} else {
			switchRhs.clear();
		}
		dataValue = RHSWidgetFactory.getRHSWidgets(treeObject, operator, values);
		rhsValuePanel.setWidget(dataValue);
	}				

	protected void setAddRowButtonVisible(boolean visible) {
		addRow.setVisible(visible);
	}

	/**
	 * Should probably be using events for this... This is called from
	 * XmlSelection when an update happens.
	 */
	public FieldSelectorHandler getLhsSelectHandler() {
		return new FieldSelectorHandler() {

			@Override
			public void onSelection(TreeItem item) {
				updateFieldLhs(item);
			}

			@Override
			public boolean isSelectable(TreeItem item) {
				return ((IFieldTreeObject) item.getUserObject()).supportsCriteriaType(root.getLhsCriteriaType(), root.getCriteriaMode());
			}
		};
	}

	/**
	 * Should probably be using events for this... This is called from
	 * XmlSelection when an update happens.
	 */
	public FieldSelectorHandler getRhsSelectHandler() {
		FieldSelectorHandler handler = new RightFieldSelectionHandler(this);
		return handler;
//		return new FieldSelectorHandler() {
//
//			@Override
//			public void onSelection(TreeItem item) {
//				updateFieldRhs(item);
//			}
//
//			@Override
//			public boolean isSelectable(TreeItem item) {
//				IFieldTreeObject tree = (IFieldTreeObject) item.getUserObject();
//				return !tree.getDataType().equals(UIDataType.COMPLEX);
//			}
//		};
	}

	/**
	 * Each row represents a predicate derived from a UI filter value node
	 * object. This method populates the row with the predicate
	 * 
	 * @param predicateNode
	 */
	private void setPredicate(UITitleFilterConditionNode predicateNode) {

		String sectionType = predicateNode.getSectionType();
		String xpath = predicateNode.getField();
		UIFieldType fieldType = predicateNode.getFieldType();
		boolean isNot = predicateNode.isNot();

		// set crap here

		if (predicateNode.getFieldLhsDisplayName() == null || predicateNode.getFieldLhsDisplayName().isEmpty()) {
			root.addWarningMessage(myMessages.invalidField(xpath + " " + xpath));
			return;
		}

		IFieldTreeObject obj = FieldTreeCreator.getFieldTreeObject(fieldType, sectionType, xpath, predicateNode.getFieldLhsDisplayName(), predicateNode.getDataType(), predicateNode.getComplexType(),
				predicateNode.getExtendedDisplayNameLhs());

		setLhsField(obj);
		filterOperatorList(obj);
		setOperatorList(predicateNode.getSearchOperator());

		this.treeObject = obj;
		// set the data value
		if (predicateNode.getRhsType().equals(RhsType.FIELD)) {
			UITitleFilterRHSFieldNode rhsPred = (UITitleFilterRHSFieldNode) predicateNode;
			rhsValuePanel.setWidget(rhsFldTxtBox);
			String xpathRhs = rhsPred.getFieldRhs();
			String sectionTypeRhs = rhsPred.getSectionTypeRhs();
			String displayNameRhs = rhsPred.getFieldRhsDisplayName();
			UIFieldType fieldTypeRhs = rhsPred.getFieldTypeRhs();
			if (displayNameRhs == null || displayNameRhs.isEmpty()) {
				root.addWarningMessage(myMessages.invalidField(sectionTypeRhs + " " + xpathRhs));
				return;
			}
			treeObjectRhs = FieldTreeCreator.getFieldTreeObject(fieldTypeRhs, sectionTypeRhs, xpathRhs, displayNameRhs, predicateNode.getDataType(), predicateNode.getComplexType(),
					rhsPred.getExtendedDisplayNameRhs());
			switchRhs.add(rhsField);
			switchRhs.add(rhsValue);
			rhsField.setValue(true);
			setRhsField(treeObjectRhs);
		} else if (predicateNode.getRhsType().equals(RhsType.VALUE)) {
			List<String> origValue = ((UITitleFilterValueNode) predicateNode).getValues();
			resetDataValue(origValue);
			List<String> value = getValue();
			if (origValue != null && !origValue.isEmpty() && origValue.get(0) != null && !origValue.get(0).isEmpty() && (value.size() == 0 || value.get(0).isEmpty())) {
				root.addWarningMessage(myMessages.invalidValue(origValue.get(0), sectionType + " " + xpath));
			}
		} else {
			resetDataValue(new ArrayList<String>(0));
		}

		this.notChkBox.setValue(isNot);
		if(isNot){
			tg.setDown(true);
		}else{
			tg.setDown(false);
		}
		if (!isEvalChild()) {
			this.root.notifyChange(obj);
		}
	}

	/*
	 * Creates the operator list. should be moved somewhere else...
	 */
	private static ListBoxWidget<BaseOperator> createOperatorList() {
		ListBoxWidget<BaseOperator> list = new ListBoxWidget<BaseOperator>();
		list.addStyleName("condition-list");
		Collection<BaseOperator> operators = BaseOperator.values();

		for (BaseOperator oper : operators) {
			String strItem = oper.toString();
			list.addItem(myConstants.getString(strItem), oper);
		}
		return list;
	}

	public boolean isEvalChild() {
		return evalChild != null;
	}

	private void setOperatorList(BaseOperator operator) {
		operatorList.setSelectedItem(operator);
		if (operatorList.getSelectedIndex() == -1) {
			root.addWarningMessage(myMessages.invalidOperator(operator.toString()));
		}
	}

	/*
	 * Creates an remove button with an appropriate click handler that adds
	 * deletes a row. Actually, it just hides it, but gets ignored when save
	 * occurs
	 */
	private Button createRemoveButton() {
		Button button = new Button();
		button.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				if (canChangePredicateRow()) {
					parentList.removeItem(PredicateRow.this);
					root.notifyRemoval(treeObject);
				}
			}
		});
		button.setTitle(myConstants.removeCriteria());
		button.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
		button.addStyleName(StyleNames.STYLE_DELETE_GROUP_BUTTON_ICON);
		return button;
	}

	private void setOperatorProvider(BaseOperator operatorProvider) {
		this.operatorProvider = operatorProvider;
	}

	private BaseOperator getOperatorProvider() {
		return this.operatorProvider;
	}

	/**
	 * Returns true if this predicate row can changed based on whether this
	 * sucker has children.
	 * 
	 * @return
	 */
	public boolean canChangePredicateRow() {
		if (this.parentList instanceof PredicateRow)
			return true;
		boolean result = true;
		if (!root.canChangePredicateRow(PredicateRow.this)) {
			result = false;
		}
		return result;
	}

	/**
	 * Validation method for this row
	 * 
	 * @return
	 */
	public boolean validate() {
		boolean result = super.validate();

		if (lhsFldTxtBox.getValue().equals("")) {
			this.lhsFldTxtBox.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
			result = false;
		}

		if (rhsField.getValue() && rhsFldTxtBox.getValue().equals("")) {
			this.rhsFldTxtBox.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
			result = false;
		} else if ((!rhsValue.isAttached() || rhsValue.getValue()) && !dataValue.validate()) {
			result = false;
		}
		return result;
	}

	public UIParamType getParamType() {
		BaseOperator operator = operatorList.getSelectedItem();
		return operator.multiValued() ? UIParamType.LIST : UIParamType.VALUE;
	}

	/**
	 * Gets the level from the top (0)
	 * 
	 * @return
	 */
	public int getLevel() {
		int i = 0;
		PredicateRowBase node = this;

		while (node != null) {
			i++;
			node = node.getParentList();
		}
		return i - 1;
	}

	public void updateFieldLhs(TreeItem item) {
		if (item != null) {
			IFieldTreeObject oldObj = treeObject;
			IFieldTreeObject itemObj = (IFieldTreeObject) item.getUserObject();

			if (oldObj != null) {
				UIDataType oldDT = oldObj.getDataType();
				UIDataType newDT = itemObj.getDataType();
				if (!oldDT.equals(newDT)) {
					rhsFldTxtBox.setValue("");
					treeObjectRhs = null;
					rhsFieldSelector = null;
				}
			}

			// More hacks for eval child field
			// if you change the field and we have an eval child children we
			// need to delete them.
			if (oldObj != null && getChildCount() > 0 && (!oldObj.getAssetType().equals(itemObj.getAssetType()) || !oldObj.getField().equals(itemObj.getField()))) {
				clearChildPanel(false);
				setAddRowButtonVisible(false);
				getOperatorList().setSelectedIndex(0);
			}

			// if the user forgot to click next before
			this.lhsFldTxtBox.removeStyleName(TitleStyleNames.PINK_BOX_STYLE);

			setLhsField(itemObj);
			setLhsTreeObject(itemObj);
			filterOperatorList(itemObj);

			/*
			 * If this is a Complex Type (Eval Child Fields) we don't need to
			 * notify change child fields are treated as part of the parent
			 * predicate and don't need to be add to actions.
			 * 
			 * If nothing has changed than we don't need to notify of change.
			 */
			IFieldTreeObject userObj = (IFieldTreeObject) item.getUserObject();
			if (!isEvalChild() && (oldObj == null || !oldObj.equals(userObj))) {
				this.root.notifyChange(userObj);
				this.root.notifyRemoval(oldObj);
			}
		} else {
			lhsFldTxtBox.setText(null);
			lhsFldTxtBox.setTitle(null);
			lhsFldTxtBox.setTitle(null);
			this.treeObject = null;
		}
	}

	public void updateFieldRhs(TreeItem item) {
		if (item != null) {
			IFieldTreeObject itemObj = (IFieldTreeObject) item.getUserObject();
			// if the user forgot to click next before
			this.lhsFldTxtBox.removeStyleName(TitleStyleNames.PINK_BOX_STYLE);
	
			setRhsField(itemObj);
			setRhsTreeObject(itemObj);
		}
		else {
		//	rhsFldTxtBox.setText(null);
		//	rhsFldTxtBox.setTitle(null);
		//	rhsFldTxtBox.setText(null);
		}
	}

	public boolean hasContents() {
		return !this.lhsFldTxtBox.getValue().equals("");
	}

	public RHSValueWidget getDataValue() {
		return this.dataValue;
	}

	public ListBoxWidget<BaseOperator> getOperatorList() {
		return operatorList;
	}

	public RhsType getRhsType() {
		if (getOperatorList().getSelectedItem().equals(BaseOperator.EVALCHILDFIELDS)) {
			return RhsType.COMPLEX;
		}
		if (rhsValue.getValue() || !rhsValue.isAttached()) {
			return RhsType.VALUE;
		}
		if (rhsField.getValue()) {
			return RhsType.FIELD;
		}
		return RhsType.VALUE;
	}

	public List<String> getValue() {
		return dataValue.getValues();
	}

	public void setLhsField(IFieldTreeObject treeObj) {
		lhsFldTxtBox.setText(treeObj.getFullDisplayName());
		lhsFldTxtBox.setTitle(treeObj.getExtendedDisplayName());
	}

	public String getLhsField() {
		return lhsFldTxtBox.getText();
	}

	public void setRhsField(IFieldTreeObject treeObj) {
		rhsFldTxtBox.setText(treeObj.getFullDisplayName());
		rhsFldTxtBox.setTitle(treeObj.getExtendedDisplayName());
	}

	public String getRhsField() {
		return rhsFldTxtBox.getText();
	}

	public IFieldTreeObject getLhsTreeObject() {
		return treeObject;
	}

	public void setLhsTreeObject(IFieldTreeObject xmlTreeObject) {
		this.treeObject = xmlTreeObject;
	}

	public void setRhsTreeObject(IFieldTreeObject xmlTreeObject) {
		this.treeObjectRhs = xmlTreeObject;
	}

	public IFieldTreeObject getRhsTreeObject() {
		return this.treeObjectRhs;
	}

	public void setNot(boolean not) {
		this.notChkBox.setValue(not);
	}

	public boolean isNot() {
		return notChkBox.getValue();
	}

	public boolean isEmptyRow() {
		// first check the left hand side
		if (getLhsTreeObject() != null)
			return false;
		// next check the rhs
		return dataValue.getValues() != null && dataValue.getValues().isEmpty() || (dataValue.getValues().size() == 1 && dataValue.getValues().get(0).isEmpty());
	}

	protected Widget buildButtonPanel() {
		HorizontalPanel panel = new HorizontalPanel();
		addRow = getAddCriterionButton();
		setAddRowButtonVisible(false);
		panel.add(addRow);
		return panel;
	}

	/*
	 * creates a container which has the brackets and the text format of the
	 * operator. this is added as a child row
	 */
	private FlexTable createContainer() {
		// create label and add to container
		// create table which has the bracket on the left and children on the
		// right column
		FlexTable tableContainer = new FlexTable();
		tableContainer.setWidget(0, 0, new Label(""));
		tableContainer.getCellFormatter().setStyleName(0, 0, "eval-child-spacing");
		VerticalPanel rightSide = new VerticalPanel();
		rightSide.add(getChildrenPanel());
		rightSide.add(buildButtonPanel());
		tableContainer.setWidget(0, 1, rightSide);
		return tableContainer;
	}

	@Override
	public void removeItem(PredicateRowBase item) {
		super.removeItem(item);
		// I HATE EVAL CHILD FIELD
		// eval child should always have a default row
		if (getChildrenPanel().getWidgetCount() == 0) {
			PredicateRow row = (PredicateRow) this;
			IFieldTreeObject obj = row.getLhsTreeObject();
			addChildRow(new PredicateRow(root, obj));
		}
	}

	private Button getAddCriterionButton() {
		Button button = new Button("Add Row");
		button.setTitle(myConstants.addCriterion());
		button.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				// eval child can suck it...
				PredicateRow row = PredicateRow.this;
				// eval child needs a special tree selector.
				IFieldTreeObject obj = row.getLhsTreeObject();
				addChildRow(new PredicateRow(root, obj));
			}
		});
		return button;
	}

	private class OperatorListChangeHandler implements ChangeHandler {
		@Override
		public void onChange(ChangeEvent event) {
			if (operatorList.getSelectedItem() == RulesOperatorFull.EVALCHILDFIELDS) {
				// eval child fields
				if (treeObject.getSimpleDisplayName() == null || treeObject.getSimpleDisplayName().isEmpty()) {
					String asset = treeObject.getAssetType();
					String xpath = treeObject.getField();
					root.addWarningMessage(myMessages.invalidField(asset + " " + xpath));
					return;
				}

				PredicateRow pred = new PredicateRow(root, treeObject);
				addChildRow(pred);
				setAddRowButtonVisible(true);
			} else {
				// just in case the last operator was eval child field clear the
				// childrenPanel
				clearChildPanel(false);
				setAddRowButtonVisible(false);
			}
			resetDataValue(dataValue.getValues());
		}
	}

	private class RhsSwitchHandler implements ClickHandler {
		@Override
		public void onClick(ClickEvent event) {
			if (rhsField.getValue()) {
				rhsValuePanel.setWidget(rhsFldTxtBox);
			} else {
				rhsValuePanel.setWidget(dataValue);
			}
		}
	}
}