package com.tandbergtv.cms.portal.ui.title.client.criteria;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetFileTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.LicenseTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.MatchedItemTreeObj;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.PMMFieldProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.PMMTitleTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UiSubscriptionProfile;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;

/**
 * This is responsible for creating the UI tree for Xpaths given an asset
 * specification
 * 
 * @author rchu
 * 
 */
public class TreeCreator {

	private static Date specLastUpdateDate;
	private static Collection<IFieldTreeObject> spec;
	private static Date contractDataLastUpdateDate;
	private static LicenseTreeObject contractData;
	private static Date meLastUpdatedDate = null;
	private static Collection<UiSubscriptionProfile> subsProfiles;
	
	public static void setSpec(FieldProviderResults providerResults) {
		FieldSelector.clearCache();
		specLastUpdateDate = providerResults.getLastUpdateDate();
		spec = providerResults.getMdmFields();
	}
	
	public static Date getSpecLastUpdateDate() {
		return specLastUpdateDate;
	}
	
	public static Collection<IFieldTreeObject> getSpec() {
		return spec;
	}
	
	public static void setContractData(LicenseTreeObject data, Date updateDate) {
		FieldSelector.clearCache();
		contractData = data;
		contractDataLastUpdateDate = updateDate;
	}

	public static LicenseTreeObject getContractData() {
		return contractData;
	}

	public static Date getContractLastUpdateDate() {
		return contractDataLastUpdateDate;
	}
	
	public static Date getMeLastUpdateDate() {
		return meLastUpdatedDate;
	}
	
	public static void setSubscriptionProfiles(Collection<UiSubscriptionProfile> subscriptionProfiles, Date lastUpdateDate) {
		FieldSelector.clearCache();
		meLastUpdatedDate = lastUpdateDate;
		subsProfiles = subscriptionProfiles;
	}

	public static List<TreeItem> getTreeItems(CriteriaType critType, UiCriteriaMode critMode) {
		// add all asset definitions to the root of the tree
		List<TreeItem> items = getMdmTreeItems(critType, critMode);
		LicenseTreeObject contractTreeObj = getContractData();
		if (ClientAuthorizationManager.isAuthorized("ContractManager_View")
				&& contractTreeObj != null
				&& contractTreeObj.childSupportsCriteriaType(critType, critMode)) {
			TreeItem item = convertToTreeItem(contractTreeObj, critType, critMode);
			if(item.getChildCount() > 0)
				items.add(item);
		}
		items.addAll(getPMMTitleItems(critType,critMode));
		if(ClientAuthorizationManager.isAuthorized("MetadataEnhancement_View")) {
			TreeItem enhancement = getEnhancementTreeItems(critType, critMode);
			if(enhancement.getChildCount() > 0)
				items.add(enhancement);
		}
		return items;
	}

	private static TreeItem getEnhancementTreeItems(
			CriteriaType critType, UiCriteriaMode critMode) {
		TreeItem metaDataEnhancementRoot = new TreeItem("Metadata Enhancement");
		if(subsProfiles == null)
			return metaDataEnhancementRoot;
		for(UiSubscriptionProfile sp : subsProfiles) {
			TreeItem spItem = new TreeItem(sp.getSimpleDisplayName());
			spItem.setUserObject(sp);
			for(IFieldTreeObject field : sp.getChildren()) {
				if(!field.supportsCriteriaType(critType, critMode))
					continue;
				TreeItem fieldItem = new TreeItem(field.getSimpleDisplayName());
				fieldItem.setUserObject(field);
				spItem.addItem(fieldItem);
			}
			if(spItem.getChildCount() > 0)
				metaDataEnhancementRoot.addItem(spItem);
				
		}
		return metaDataEnhancementRoot;
	}

	private static List<TreeItem> getMdmTreeItems(CriteriaType critType, UiCriteriaMode critMode) {
		List<TreeItem> items = new ArrayList<TreeItem>();
		for (IFieldTreeObject treeObj : spec) {
			if(treeObj.childSupportsCriteriaType(critType, critMode)) {
				
					items.add(convertToTreeItem(treeObj, critType, critMode));
				} 
		}
		return items;
	}

	private static List<TreeItem> getPMMTitleItems(CriteriaType critType, UiCriteriaMode critMode) {
		List<TreeItem> items = new ArrayList<TreeItem>();
		for (PMMTitleTreeObject treeObj : PMMFieldProvider.getPMMTreeObjects(critMode)) {
			//CriteriaMode doesn't matter here
			if (treeObj.supportsCriteriaType(critType, UiCriteriaMode.EPISODE)) {
				TreeItem item = new TreeItem(treeObj.getSimpleDisplayName());
				item.setUserObject(treeObj);
				items.add(item);
			}
		}

		return items;
	}

	public static TreeItem convertToTreeItem(IFieldTreeObject treeObj, CriteriaType critType, UiCriteriaMode critMode) {
		IFieldTreeObject rootMatched = null;
		if(treeObj instanceof MatchedItemTreeObj) {
			rootMatched = ((MatchedItemTreeObj) treeObj).getParent();
			treeObj = ((MatchedItemTreeObj) treeObj).getUserObject();
		}
		if (treeObj.getChildren() != null && treeObj.getChildren().size() == 0
				&& treeObj.getDataType().equals(UIDataType.COMPLEX)) {
			try {
				treeObj = findMdmObject(treeObj.getAssetType(), treeObj.getField(), critType);
			} catch (UndefinedFieldException e) {
				e.printStackTrace();
			}
		}
		return convertToTreeItemRec(treeObj, critType, critMode, rootMatched);
	}

	private static TreeItem convertToTreeItemRec(IFieldTreeObject treeObj,
			CriteriaType critType, UiCriteriaMode critMode,
			IFieldTreeObject rootMatched) {
		List<IFieldTreeObject> children = treeObj.getChildren();
		IFieldTreeObject usrObj = getUserObject(treeObj, rootMatched);
		TreeItem item = new TreeItem(usrObj.getSimpleDisplayName());
		item.setUserObject(usrObj);
		if(children != null)
			for(IFieldTreeObject child : children)
				if (child.childSupportsCriteriaType(critType, critMode)) {
				//	if(child instanceof AssetTreeObject) {
						item.addItem(convertToTreeItemRec(child, critType, critMode, rootMatched));
				//	}
				}
		return item;
	}
	
	private static IFieldTreeObject getUserObject(IFieldTreeObject treeObject, IFieldTreeObject rootMatched) {
		if(rootMatched != null) {
			return new MatchedItemTreeObj(treeObject, rootMatched);
		}
		return treeObject;
	}
	
	public static IFieldTreeObject findMdmObject(String assetType, String xpath) throws UndefinedFieldException {
		return findMdmObject(assetType, xpath, CriteriaType.BASIC_METADATA);
	}

	public static IFieldTreeObject findMdmObject(String assetType, String xpath, CriteriaType critType) throws UndefinedFieldException {
		Iterator<IFieldTreeObject> currIterator = spec.iterator();
		IFieldTreeObject asset = null;
		boolean isNew = false;
		String correctedAssetType = assetType;
		if(correctedAssetType.startsWith("NEW/")) {
			correctedAssetType = correctedAssetType.substring(4);
			isNew = true;
		}
		while(currIterator.hasNext()) {
			IFieldTreeObject treeObj = currIterator.next();
			if ((treeObj instanceof AssetTreeObject || treeObj instanceof AssetFileTreeObject)
					&& treeObj.getFieldType().equals(UIFieldType.ASSET)
					&& treeObj.getAssetType().equals(correctedAssetType)) {
				asset = treeObj;
				break;
			}
			if (treeObj instanceof AssetTreeObject && treeObj.getFieldType().equals(UIFieldType.ASSET)
					&& correctedAssetType.startsWith(treeObj.getAssetType())) {
				currIterator = treeObj.getChildren().iterator();
			}
		}
		if(asset == null) {
			throw new UndefinedFieldException("Couldn't locate asset path " + correctedAssetType);
		}

		if(isNew) {
			IFieldTreeObject temp = new AssetTreeObject(asset.getFullDisplayName(), assetType, asset.getComplexType(), asset.getExtendedDisplayName());
			temp.setChildren(asset.getChildren());
			asset = temp;
		}
		
		if(assetType.endsWith("/FILE") && xpath.isEmpty()) {
			return asset;
		} else if((critType.equals(CriteriaType.MSO_ACTION_LHS) || critType.equals(CriteriaType.NORM_ACTION_LHS)) && xpath.isEmpty()) {
			return ((AssetTreeObject) asset).cloneWithoutChildAssetFields();
		} else if(xpath.isEmpty()) {
			return ((AssetTreeObject)asset).cloneWithoutChildAsset();
		}
		
		currIterator = asset.getChildren().iterator();
		while(currIterator.hasNext()) {
			IFieldTreeObject treeObj = currIterator.next();
			if (treeObj instanceof AssetFieldTreeObject
					&& treeObj.getAssetType().equals(correctedAssetType)
					&& treeObj.getField().equals(xpath)) {
				return treeObj;
			}
			
			if (treeObj instanceof AssetFieldTreeObject
					&& treeObj.getAssetType().equals(correctedAssetType)
					&& xpath.startsWith(treeObj.getField())) {
			    // only go to child level when the delta is start with "/"
			    String delta = xpath.substring(treeObj.getField().length());
			    if (delta.startsWith("/")) {
			        currIterator = treeObj.getChildren().iterator();
			    } 			    
			}
		}
		throw new UndefinedFieldException("Couldn't locate xpath " + xpath);
	}

	
}
