package com.tandbergtv.cms.portal.ui.title.client.criteria;

import java.util.List;

import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;

public class TreeOpenHandler implements OpenHandler<TreeItem> {

	@Override
	public void onOpen(OpenEvent<TreeItem> event) {
		final TreeItem item = event.getTarget();
		if(item.getChildCount() == 0) {
			IFieldTreeObject treeObj = (IFieldTreeObject)item.getUserObject();
			List<IFieldTreeObject> children = treeObj.getChildren();
			if(children == null)
				return ;
			for(IFieldTreeObject child : children) {
				TreeItem childItem = new TreeItem(child.getSimpleDisplayName());
				childItem.setUserObject(child);
				item.addItem(childItem);
			}
		}
	}

}
