package com.tandbergtv.cms.portal.ui.title.client.criteria;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;

public class TreeSearcher extends HorizontalPanel implements HasSelectionHandlers<TreeItem> {

	private TextBox txtBox =null;
//	private Button minimize;
	private Tree tree = null;
	private String lastSearch = "";
	private boolean lastSearchResultedInMatch = true;
	private Integer hitNumber = 0;
	private ItemSelectableHandler selectableChecker;

	public TreeSearcher(Tree tree, SelectionHandler<TreeItem> handler, ItemSelectableHandler selectableChecker) {
		this.selectableChecker = selectableChecker;
		
		this.tree = tree;
		this.txtBox = new TextBox();
		this.addSelectionHandler(handler);
//		minimize = new Button("-");
//		minimize.addClickHandler(new ClickHandler() {
//			@Override
//			public void onClick(ClickEvent event) {
//				collapseAll();
//			}
//		});
		txtBox.addKeyUpHandler( new KeyUpHandler() {
			@Override
			public void onKeyUp(KeyUpEvent event) {
				String txt = txtBox.getText();
				if (!txt.isEmpty()
						&& (lastSearch != txt || event.getNativeKeyCode() == KeyCodes.KEY_ENTER)
						&& event.getNativeKeyCode() != KeyCodes.KEY_BACKSPACE
						&& (!txt.startsWith(lastSearch) || lastSearchResultedInMatch))
					findItem(txt, event.getNativeKeyCode() == KeyCodes.KEY_ENTER);
				setFocus();
			}
		});
		txtBox.setWidth("95%");

	//	txtBox.addStyleName("field-selector-srchBox");
		add(txtBox);
		this.setWidth("100%");
	//	add(minimize);
		//this.setCellWidth(txtBox, "100%");
		//this.setCellHorizontalAlignment(txtBox, ALIGN_LEFT);
		//this.setCellHorizontalAlignment(minimize, ALIGN_RIGHT);
	}

	public void setFocus() {
		txtBox.setFocus(true);
		Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand () {
	        public void execute () {
	        	txtBox.setFocus(true);
	        }
	    });
	}

	protected void collapseAll() {
		for(int i=0; i < tree.getItemCount(); i++) {
			TreeItem item = tree.getItem(i);
			if(item.getState() && !collapseHelper(item))
					item.setState(false, false);
		}
	}
	
	private boolean collapseHelper(TreeItem parent) {
		boolean result = false;
		for(int i=0; i < parent.getChildCount(); i++) {
			TreeItem item = parent.getChild(i);
			boolean childResult = collapseHelper(item);
			if(item.getState() && !childResult) {
				item.setState(false, false);
			} else if(childResult || item.isSelected()) {
				result = true;
			}

		}
		return result;
	}

	public void reset() {
		txtBox.setText("");
		lastSearch = "";
		lastSearchResultedInMatch = true;
		hitNumber = 0;
	}
	
	public void findItem(String search, boolean next) {
		//if fieldTree also exists , search it also
		if(!next) {
			hitNumber = 0;
		}
		boolean foundItem = false;
		MutableInteger searchHit = new MutableInteger(0);
		for(int i=0; i < tree.getItemCount(); i++) {
			TreeItem item = tree.getItem(i);
			if(searchHelper(item, searchHit, search)) {
				foundItem = true;
				break;
			}
		}
		
		lastSearch = search;
		lastSearchResultedInMatch = foundItem;
	}
	
	private boolean findItemInTree(TreeItem parent, MutableInteger searchHit, String search) {
		for(int i=0; i < parent.getChildCount(); i++) {
			TreeItem item = parent.getChild(i);
			if(searchHelper(item, searchHit, search)) {
				return true;
			}
		}
		return false;
	}
	
	private boolean searchHelper(TreeItem item, MutableInteger searchHit, String search) {
		if(item.getText().toUpperCase().startsWith(search.toUpperCase()) && (selectableChecker == null || selectableChecker.isSelectable(item))) {
			if(hitNumber == searchHit.value) {
				SelectionEvent.fire(this, item);
				hitNumber++;
				return true;
			} else {	
				searchHit.value++;
			}
		}
		return findItemInTree(item, searchHit, search);
	}
	
	private class MutableInteger {
		public int value;
		
		public MutableInteger(int value) {
			this.value = value;
		}
	}

	@Override
	public HandlerRegistration addSelectionHandler(
			SelectionHandler<TreeItem> handler) {
		return addHandler(handler, SelectionEvent.getType());
	}
}
