package com.tandbergtv.cms.portal.ui.title.client.criteria;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.MatchedItemTreeObj;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.PMMFieldProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.PMMTitleTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;

/**
 * This is responsible for creating the UI tree for Xpaths given an asset
 * specification
 * 
 * @author Daniel Weiner
 * 
 */
public class TypedTreeCreator {
	
	public static List<TreeItem> getTreeItems(CriteriaType critType, UiCriteriaMode critMode, UIDataType dataType, boolean includeString) {
		// add all asset definitions to the root of the tree
		List<TreeItem> items = getMdmTreeItems(critType, critMode, dataType, includeString);
		if (ClientAuthorizationManager.isAuthorized("ContractManager_View")) {
			TreeItem item = convertToTreeItem(TreeCreator.getContractData(), critType, critMode, dataType, includeString);
			if(item != null)
				items.add(item);
		}
		items.addAll(getPMMTitleItems(critType, dataType, critMode));
		return items;
	}
	
	public static List<TreeItem> getTreeItems(CriteriaType critType, UiCriteriaMode critMode, String complexType) {
		// add all asset definitions to the root of the tree
		List<TreeItem> items = new ArrayList<TreeItem>();
		for (IFieldTreeObject treeObj : TreeCreator.getSpec()) {
			if(treeObj.childSupportsCriteriaType(critType, critMode)) {
				TreeItem item = convertToTreeItem(treeObj, critType, critMode, complexType);
				if(item != null) {
					items.add(item);
				}

			}
		}
		return items;
	}

	private static List<TreeItem> getMdmTreeItems(CriteriaType critType, UiCriteriaMode critMode, UIDataType dataType, boolean includeString) {
		List<TreeItem> items = new ArrayList<TreeItem>();
		for (IFieldTreeObject treeObj : TreeCreator.getSpec()) {
			if(!treeObj.childSupportsCriteriaType(critType, critMode))
				continue;
			TreeItem childItem = convertToTreeItem(treeObj, critType, critMode,	dataType, includeString);
			if (childItem != null)
				items.add(childItem);
		}
		return items;
	}
	
	public static TreeItem convertToTreeItem(IFieldTreeObject treeObj, CriteriaType critType, UiCriteriaMode critMode, UIDataType baseDataType, boolean includeString) {
		IFieldTreeObject rootMatched = null;
		if(treeObj instanceof MatchedItemTreeObj) {
			rootMatched = ((MatchedItemTreeObj) treeObj).getParent();
			treeObj = ((MatchedItemTreeObj) treeObj).getUserObject();
		}
		if (treeObj.getChildren() != null && treeObj.getChildren().size() == 0
				&& treeObj.getDataType().equals(UIDataType.COMPLEX)) {
			try {
				treeObj = TreeCreator.findMdmObject(treeObj.getAssetType(), treeObj.getField(), critType);
			} catch (UndefinedFieldException e) {
				e.printStackTrace();
			}
		}
		TreeItem result = convertToTreeItemRec(treeObj, critType, critMode, baseDataType, includeString, rootMatched);
		if (result.getChildCount() > 0
				|| (validDataType(baseDataType, treeObj.getDataType(),
						includeString) && treeObj.supportsCriteriaType(critType, critMode)))
			return result;
		return null;
	}

	public static TreeItem convertToTreeItemRec(IFieldTreeObject treeObj, CriteriaType critType, UiCriteriaMode critMode, UIDataType baseDataType, boolean includeString, IFieldTreeObject rootMatched) {
		List<IFieldTreeObject> children = treeObj.getChildren();
		IFieldTreeObject usrObj = getUserObject(treeObj, rootMatched);
		TreeItem item = new TreeItem(usrObj.getSimpleDisplayName());
		item.setUserObject(usrObj);
		if(children != null)
			for(IFieldTreeObject child : children) {
				UIDataType fieldDataType = child.getDataType();
				TreeItem childItem = convertToTreeItemRec(child, critType, critMode,	baseDataType, includeString, rootMatched);
				if (childItem.getChildCount() > 0
						|| (validDataType(baseDataType, fieldDataType,
								includeString) && child
								.supportsCriteriaType(critType, critMode)))
					item.addItem(childItem);
			}
		return item;
	}

	public static TreeItem convertToTreeItem(IFieldTreeObject treeObj, CriteriaType critType, UiCriteriaMode critMode, String complexType) {
		IFieldTreeObject rootMatched = null;
		if(treeObj instanceof MatchedItemTreeObj) {
			rootMatched = ((MatchedItemTreeObj) treeObj).getParent();
			treeObj = ((MatchedItemTreeObj) treeObj).getUserObject();
		}
		if (treeObj.getChildren() != null && treeObj.getChildren().size() == 0
				&& treeObj.getDataType().equals(UIDataType.COMPLEX)) {
			try {
				treeObj = TreeCreator.findMdmObject(treeObj.getAssetType(), treeObj.getField(), critType);
			} catch (UndefinedFieldException e) {
				e.printStackTrace();
			}
		}
		TreeItem result = convertToTreeItemRec(treeObj, critType, critMode, complexType, rootMatched);
		if (result.getChildCount() > 0
				|| (result != null
						&& complexType.equals(treeObj.getComplexType()) && treeObj
							.supportsCriteriaType(critType, critMode)))
			return result;
		return null;
	}
	
	public static TreeItem convertToTreeItemRec(IFieldTreeObject treeObj, CriteriaType critType, UiCriteriaMode critMode, String complexType, IFieldTreeObject rootMatched) {
		List<IFieldTreeObject> children = treeObj.getChildren();
		IFieldTreeObject usrObj = getUserObject(treeObj, rootMatched);
		TreeItem item = new TreeItem(usrObj.getSimpleDisplayName());
		item.setUserObject(usrObj);
		if(children != null)
			for(IFieldTreeObject child : children) {
				String fieldType = child.getComplexType();
				TreeItem childItem = convertToTreeItemRec(child, critType, critMode, complexType, rootMatched);
				if (childItem.getChildCount() > 0
						|| (fieldType != null && complexType.equals(fieldType) && child
								.supportsCriteriaType(critType, critMode)))
					item.addItem(childItem);
			}
		return item;
	}
	
	private static IFieldTreeObject getUserObject(IFieldTreeObject treeObject, IFieldTreeObject rootMatched) {
		if(rootMatched != null) {
			return new MatchedItemTreeObj(treeObject, rootMatched);
		}
		return treeObject;
	}

	private static List<TreeItem> getPMMTitleItems(CriteriaType critType, UIDataType dataType, UiCriteriaMode critMode) {
		List<TreeItem> items = new ArrayList<TreeItem>();
		for (PMMTitleTreeObject treeObj : PMMFieldProvider
				.getPMMTreeObjects(critMode)) {
			if (treeObj.supportsCriteriaType(critType, UiCriteriaMode.EPISODE) && treeObj.getDataType().equals(dataType)) {
				TreeItem item = new TreeItem(treeObj.getSimpleDisplayName());
				item.setUserObject(treeObj);
				items.add(item);
			}
		}

		return items;
	}
	
	public static boolean validDataType(UIDataType baseDataType, UIDataType fieldDataType, boolean includeString) {
		if(fieldDataType == null)
			return false;
		if(includeString && fieldDataType.equals(UIDataType.STRING))
				return true;

		switch(baseDataType) {
		case STRING:
			return fieldDataType.equals(UIDataType.STRING);
		case INTEGER:
			return fieldDataType.equals(UIDataType.INTEGER);
		case FLOAT:
			return fieldDataType.equals(UIDataType.FLOAT);
		case BOOLEAN:
			return fieldDataType.equals(UIDataType.BOOLEAN);
		case DATE:
			return fieldDataType.equals(UIDataType.DATE);
		case TIME:
			return fieldDataType.equals(UIDataType.TIME);
		default:
			return false;
		}
	}
}
