/*
 * Copyright 2009 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.tandbergtv.cms.portal.ui.title.client.criteria.data;

import java.util.Date;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.datepicker.client.DateBox;
import com.google.gwt.user.datepicker.client.DatePicker;

/**
 * A text box that shows a {@link DatePicker} when the user focuses on it.
 *
 * <h3>CSS Style Rules</h3>
 *
 * <dl>
 * <dt>.gwt-DateBox</dt>
 * <dd>default style name</dd>
 * <dt>.dateBoxPopup</dt>
 * <dd>Applied to the popup around the DatePicker</dd>
 * <dt>.dateBoxFormatError</dt>
 * <dd>Default style for when the date box has bad input. Applied by
 * {@link NoClickDateBox.DefaultFormat} when the text does not represent a date that
 * can be parsed</dd>
 * </dl>
 *
 * <p>
 * <h3>Example</h3>
 * {@example com.google.gwt.examples.DateBoxExample}
 * </p>
 */
public class NoClickDateBox extends DateBox  {

  private class DateBoxHandler implements ValueChangeHandler<Date>,
      FocusHandler, BlurHandler, ClickHandler, KeyDownHandler,
      CloseHandler<PopupPanel> {

    public void onBlur(BlurEvent event) {
    	hideDatePicker();
    }

    public void onClick(ClickEvent event) {
    	hideDatePicker();
    }

    public void onClose(CloseEvent<PopupPanel> event) {
    	hideDatePicker();
    }

    public void onFocus(FocusEvent event) {
    	hideDatePicker();
    }

    public void onKeyDown(KeyDownEvent event) {
    	hideDatePicker();
    }

    public void onValueChange(ValueChangeEvent<Date> event) {
    	hideDatePicker();
    }
  }
  
  /**
   * Default style name.
   */
  public static final String DEFAULT_STYLENAME = "gwt-DateBox";
  private static final DefaultFormat DEFAULT_FORMAT = GWT.create(DefaultFormat.class);
  //private final PopupPanel popup;
  //private final TextBox box = new TextBox();

  /**
   * Create a date box with a new {@link DatePicker}.
   */
  public NoClickDateBox() {
	  this(new DatePicker(), null, DEFAULT_FORMAT);
  }

  /**
   * Create a new date box.
   *
   * @param date the default date.
   * @param picker the picker to drop down from the date box
   * @param format to use to parse and format dates
   */
  public NoClickDateBox(DatePicker picker, Date date, Format format) {
	  super(picker, date, format);

	  DateBoxHandler handler = new DateBoxHandler();
	  //picker.addValueChangeHandler(handler);
	  this.getTextBox().addFocusHandler(handler);
	  this.getTextBox().addBlurHandler(handler);
	  this.getTextBox().addClickHandler(handler);
	  this.getTextBox().addKeyDownHandler(handler);
	  this.getTextBox().setDirectionEstimator(false);
	  //popup.addCloseHandler(handler);
	  setValue(date);
  }

}
