package com.tandbergtv.cms.portal.ui.title.client.criteria.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.TitleStyleNames;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;

public class RHSDateRangeWidget extends RHSValueWidget {
    private TitleConstants myConstants = (TitleConstants) GWT.create(TitleConstants.class);
    protected ValueDateBox1 start;
    protected ValueDateBox1 end;
    private NoClickDateBox startNoClickDateBox, endNoClickDateBox;

    public RHSDateRangeWidget() {
	start = new ValueDateBox1();
	end = new ValueDateBox1();
	HorizontalPanel panel = new HorizontalPanel();
	panel.setVerticalAlignment(HorizontalPanel.ALIGN_MIDDLE);
	ImageWidget imageWidget1 = new ImageWidget("cms_title_ui/resources/images/icon_cal.png");
	ImageWidget imageWidget2 = new ImageWidget("cms_title_ui/resources/images/icon_cal.png");
	imageWidget1.setStyleName("date-box-selector-icon");
	imageWidget2.setStyleName("date-box-selector-icon");

	ImageWidget cross_icon1 = new ImageWidget("cms_contentmgmt_ui/resources/images/icon_close.png");
	ImageWidget cross_icon2 = new ImageWidget("cms_contentmgmt_ui/resources/images/icon_close.png");
	cross_icon1.setStyleName("date-box-cross-icon");
	cross_icon2.setStyleName("date-box-cross-icon");
	startNoClickDateBox = start.getDateBox();
	endNoClickDateBox = end.getDateBox();

	cross_icon1.addClickHandler(new ClickHandler() {
	    @Override
	    public void onClick(ClickEvent event) {
		startNoClickDateBox = start.getDateBox();
		startNoClickDateBox.hideDatePicker();
		startNoClickDateBox.getTextBox().setText("");
		startNoClickDateBox.getTextBox().removeStyleName(TitleStyleNames.PINK_BOX_STYLE);
	    }
	});

	cross_icon2.addClickHandler(new ClickHandler() {
	    @Override
	    public void onClick(ClickEvent event) {
		endNoClickDateBox = end.getDateBox();
		endNoClickDateBox.hideDatePicker();
		endNoClickDateBox.getTextBox().setText("");
		endNoClickDateBox.getTextBox().removeStyleName(TitleStyleNames.PINK_BOX_STYLE);
	    }
	});

	panel.add(start);
	panel.add(cross_icon1);
	panel.add(imageWidget1);
	imageWidget1.addClickHandler(new ClickHandler() {
	    @Override
	    public void onClick(ClickEvent event) {

		if (start.getDateBox().isDatePickerShowing()) {
		    start.getDateBox().hideDatePicker();
		} else if (!start.getDateBox().isDatePickerShowing()) {
		    start.getDateBox().showDatePicker();
		} else {
		    start.getDateBox().hideDatePicker();
		}
	    }
	});

	imageWidget2.addClickHandler(new ClickHandler() {
	    @Override
	    public void onClick(ClickEvent event) {

		if (end.getDateBox().isDatePickerShowing()) {
		    end.getDateBox().hideDatePicker();
		} else if (!end.getDateBox().isDatePickerShowing()) {
		    end.getDateBox().showDatePicker();
		} else {
		    end.getDateBox().hideDatePicker();
		}
	    }
	});
	// TODO add to properties file
	Label and = new Label(myConstants.and());
	and.setStyleName("date-box-and-label");
	panel.add(and);
	panel.add(end);
	panel.add(cross_icon2);
	panel.add(imageWidget2);
	add(panel);
	panel.setSpacing(3);
    }

    @Override
    public List<String> getValues() {
	List<String> result = new ArrayList<String>();
	result.add(start.getValue());
	result.add(end.getValue());
	return result;
    }

    @Override
    public boolean validate() {
	boolean startValid = start.validate();
	boolean endValid = end.validate();
	return startValid && endValid;
    }

    @Override
    public void setValues(String value) {
      start.setValue(value);
      end.setValue(value);
    }

    public void addValueChangeHandler(ValueChangeHandler<Date> handler) {
	start.addValueChangeHandler(handler);
	end.addValueChangeHandler(handler);
    }
    
    public void addBlurHandler(BlurHandler handler) {
	startNoClickDateBox.getTextBox().addBlurHandler(handler);
	endNoClickDateBox.getTextBox().addBlurHandler(handler);
    }
    
    public void removeHightlight(){
	startNoClickDateBox.getTextBox().removeStyleName(TitleStyleNames.PINK_BOX_STYLE);
	endNoClickDateBox.getTextBox().removeStyleName(TitleStyleNames.PINK_BOX_STYLE);
    }
}
