package com.tandbergtv.cms.portal.ui.title.client.criteria.data;

import java.util.Collection;
import java.util.List;

import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.FloatValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.IRulesValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.LongValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.StringValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.TimeValidator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIParamType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperatorLimited;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;

public class RHSWidgetFactory {

	public static RHSValueWidget getRHSWidgets(IFieldTreeObject treeObject,
			BaseOperator operator, List<String> values) {
		UIDataType dataType = treeObject.getDataType();
		boolean listableDataType = dataType.equals(UIDataType.INTEGER)
				|| dataType.equals(UIDataType.FLOAT)
				|| dataType.equals(UIDataType.STRING);
		if(operator == null)
			return handleNullOperator(values);
		if (operator.multiValued() && listableDataType) {
			return new ValueList(treeObject, operator, values);
		} else {
			String value = null;
			if (values != null && values.size() > 0) {
				value = values.get(0);
			}
			return new SimpleRHSValueWidget(getRHSWidget(treeObject, operator,
					value));
		}
	}
	
	private static RHSValueWidget handleNullOperator(List<String> values) {
		if(values.size() == 0) {
			return new SimpleRHSValueWidget(new ValueTextBox(new StringValidator())); 
		} else {
			return new SimpleRHSValueWidget(new ValueTextBox(new StringValidator(), values.get(0)));
		}
	}

	public static SingleValueWidget getRHSWidget(IFieldTreeObject treeObject,
			BaseOperator operator, String value) {
		UIDataType dataType = treeObject.getDataType();

		// If we can't build anything yet go ahead and return an empty text box
		if (treeObject == null || operator == null) {
			return new ValueTextBox(new StringValidator());
		}

		boolean useOther = treeObject.supportsOther();
		Collection<UIValueOption> suggestedValues = null; 
		if (operator.useSuggestedValues() && treeObject.supportsSuggestValues()) {
			suggestedValues = treeObject.getSuggestedValues();
		}
		if (operator.equals(BaseOperator.NUMINSTANCESEQUAL)
				|| operator.equals(BaseOperator.NUMINSTANCESGREATERTHAN)
				|| operator.equals(BaseOperator.NUMINSTANCESLESSTHAN)) {
			return buildValTextBox(new LongValidator(0, Integer.MAX_VALUE),
					value, suggestedValues, useOther);
		} else if (operator.equals(BaseOperator.LENGTHEQUALS)
				|| operator.equals(BaseOperator.LENGTHGREATERTHAN)
				|| operator.equals(BaseOperator.LENGTHLESSTHAN)
				|| operator.equals(BaseOperator.TOTALLENGTHEQUALS)
				|| operator.equals(BaseOperator.TOTALLENGTHGREATERTHAN)
				|| operator.equals(BaseOperator.TOTALLENGTHLESSTHAN)) {
			return buildValTextBox(new LongValidator(0, Integer.MAX_VALUE),
					value, suggestedValues, useOther);
		} else if (operator.equals(BaseOperator.TIMEEQUALS)
				|| operator.equals(BaseOperator.TIMEGREATERTHAN)
				|| operator.equals(BaseOperator.TIMELESSTHAN)) {
			return buildValTextBox(new TimeValidator(),
					value, suggestedValues, useOther);
		} else if (operator.equals(BaseOperator.GREATERTHANTODAY)
				|| operator.equals(BaseOperator.LESSTHANTODAY)) {
			return buildValTextBox(new LongValidator(Integer.MIN_VALUE,
					Integer.MAX_VALUE), value, suggestedValues, useOther);
		} else if (operator.getParamType().equals(UIParamType.NONE)) {
			return new EmptyRHS();
		} else if (operator.equals(RulesOperatorLimited.REGEX)) {
			return new RegexValueWidget(value);
		} else {
			switch(dataType) {
			case COMPLEX:
				return new EmptyRHS();
			case INTEGER:
				return buildValTextBox(new LongValidator(), value, suggestedValues, useOther);
			case STRING:	
				return buildValTextBox(new StringValidator(), value, suggestedValues, useOther);
			case BOOLEAN:
				return BuildBooleanBox(value);
			case FLOAT:
				return buildValTextBox(new FloatValidator(), value, suggestedValues, useOther);
			case DATE:
				return buildDateBox(value);
			case TIME:
				return buildValTextBox(new TimeValidator(), value, suggestedValues, useOther);
			}
		}
		return new ValueTextBox(new StringValidator());
	}

	private static SingleValueWidget buildValTextBox(IRulesValidator validator,
			String value, Collection<UIValueOption> suggestedValues, boolean useOther) {
		if ((value == null || value.isEmpty()) && suggestedValues == null) {
			return new ValueTextBox(validator);
		} else if (value == null || value.isEmpty()) {
			return new ValueTextBox(validator, suggestedValues, useOther);
		} else if (suggestedValues == null) {
			return new ValueTextBox(validator, value);
		} else {
			return new ValueTextBox(validator, suggestedValues, useOther, value);
		}
	}

	private static SingleValueWidget buildDateBox(String value) {
		if (value == null || value.isEmpty()) {
			return new ValueDateBox();
		} else {
			return new ValueDateBox(value);
		}
	}

	private static SingleValueWidget BuildBooleanBox(String value) {
		if (value == null || value.isEmpty()) {
			return new ValueBooleanBox();
		} else {
			return new ValueBooleanBox(value);
		}
	}
}
