package com.tandbergtv.cms.portal.ui.title.client.criteria.data;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.TextBox;
import com.tandbergtv.cms.portal.ui.title.client.TitleStyleNames;
import com.tandbergtv.cms.portal.ui.title.client.criteria.regex.RegexDoneEvent;
import com.tandbergtv.cms.portal.ui.title.client.criteria.regex.RegexDoneHandler;
import com.tandbergtv.cms.portal.ui.title.client.criteria.regex.RegexEditor;
import com.tandbergtv.cms.portal.ui.title.client.criteria.regex.UiRegexValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.regex.UiRegexValidatorAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class RegexValueWidget extends SingleValueWidget {
	protected final UiRegexValidatorAsync regexService = GWT
			.create(UiRegexValidator.class);

	private TextBox value = new TextBox();
	private boolean isValidRegex = false;
	private RegexEditor editor = new RegexEditor();

	public RegexValueWidget(final String regex) {
		super();
		value = new TextBox();
		value.addStyleName("small-txt");
		value.setVisibleLength(60);
		setValue(regex);

		editor.addRegexDoneHandler(new RegexDoneHandler() {

			@Override
			public void doneEditing(RegexDoneEvent event) {
				value.setText(event.getValue());
				value.removeStyleName(TitleStyleNames.PINK_BOX_STYLE);
				isValidRegex = true;
			}

		});

		value.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				editor.setRegex(value.getValue());
				editor.center();
			}

		});
		setWidget(value);
	}

	@Override
	public void onUnload() {
		super.onUnload();
		editor.hide();
	}

	@Override
	public String getValue() {
		return value.getValue();
	}

	@Override
	public boolean validate() {
		boolean valid = isValidRegex && !value.getValue().isEmpty();
		if (!valid) {
			value.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
		}
		return valid;
	}

	@Override
	public void setValue(String regex) {
		if (regex != null && !regex.isEmpty()) {
			value.setValue(regex);
			regexService.validateRegex(regex,
					new NeptuneAsyncCallback<Boolean>() {

						@Override
						public void onNeptuneFailure(Throwable caught) {
							Window.alert("Unexpected error while validating regular expression");
						}

						@Override
						public void onNeptuneSuccess(Boolean result) {
							if (result) {
								isValidRegex = true;
								value.removeStyleName(TitleStyleNames.PINK_BOX_STYLE);
							} else {
								isValidRegex = false;
								value.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
							}
						}
					});
		}
	}
}
