package com.tandbergtv.cms.portal.ui.title.client.criteria.data;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.shared.HandlerRegistration;

public class SimpleRHSValueWidget extends RHSValueWidget {

    private SingleValueWidget value;

    public SimpleRHSValueWidget(SingleValueWidget value) {
	this.value = value;
	add(value);
    }

    @Override
    public List<String> getValues() {
	List<String> values = new ArrayList<String>();
	if (value != null && value.getValue() != null) {
	    values.add(value.getValue());
	}
	return values;
    }

    @Override
    public void setValues(String value) {
	this.value.setValue(value);
    }

    @Override
    public boolean validate() {
	return value.validate();
    }

    public HandlerRegistration addBlurHandler(BlurHandler handler) {
	return value.addBlurHandler(handler);
    }
}
