package com.tandbergtv.cms.portal.ui.title.client.criteria.data;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.events.RHSValueChangeEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;

public class ValueBooleanBox extends SingleValueWidget {

	private TitleConstants myConstants = (TitleConstants) GWT
			.create(TitleConstants.class);

	public ValueBooleanBox() {
		super();
		ListBoxWidget<Boolean> boolWidget = new ListBoxWidget<Boolean>();
		boolWidget.addItem(myConstants.falseText(), false);
		boolWidget.addItem(myConstants.trueText(), true);
		boolWidget.setSelectedIndex(0);
		setWidget(boolWidget);
		boolWidget.addChangeHandler(new ChangeHandler() {

			@Override
			public void onChange(ChangeEvent event) {
				RHSValueChangeEvent chngEvent = new RHSValueChangeEvent();
				fireEvent(chngEvent);
			}
			
		});
	}
	
	public ValueBooleanBox(String value) {
		this();
		setValue(value);
	}

	@Override
	public String getValue() {
		return getBoolBox().getSelectedItem().toString();
	}

	@SuppressWarnings("unchecked")
	private ListBoxWidget<Boolean> getBoolBox() {
		return (ListBoxWidget<Boolean>) getWidget();
	}

	@Override
	public boolean validate() {
		return true;
	}

	@Override
	public void setValue(String value) {
		getBoolBox().setSelectedItem(Boolean.parseBoolean(value));
	}
}
