package com.tandbergtv.cms.portal.ui.title.client.criteria.data;

import java.util.Date;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.TitleStyleNames;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.events.RHSValueChangeEvent;

public class ValueDateBox1 extends SingleValueWidget {

    private static final int VISIBLE_LENGTH = 12;
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private TitleConstants myConstants = (TitleConstants) GWT.create(TitleConstants.class);
    private DateTimeFormat dateFormater = DateTimeFormat.getFormat(DATE_FORMAT);

    public ValueDateBox1() {
	super();
	// add the date picker
	NoClickDateBox dateBox = new NoClickDateBox();
	dateBox.setTitle(myConstants.validDateTitle() + " " + dateFormater.getPattern());
	NoClickDateBox.DefaultFormat fmt = new NoClickDateBox.DefaultFormat(dateFormater);
	dateBox.getTextBox().setVisibleLength(VISIBLE_LENGTH);
	dateBox.setFormat(fmt);
	dateBox.setTitle(myConstants.validDateTitle() + " " + dateFormater.getPattern());
	dateBox.addValueChangeHandler(new ValueChangeHandler<Date>() {

	    @Override
	    public void onValueChange(ValueChangeEvent<Date> event) {
		validate();
		RHSValueChangeEvent chngEvent = new RHSValueChangeEvent();
		fireEvent(chngEvent);
	    }

	});
	setWidget(dateBox);
    }

    public ValueDateBox1(String date) {
	this();
	if (!date.isEmpty()) {
	    setValue(date);
	}
    }

    @Override
    public String getValue() {
	Date value = getDateBox().getValue();
	if (value == null)
	    return getDateBox().getTextBox().getValue();
	return addTime(dateFormater.format(value));
    }

    @Override
    public boolean validate() {
	getDateBox().getTextBox().removeStyleName(TitleStyleNames.PINK_BOX_STYLE);
	boolean valid = getDateBox().getValue() != null;
	if (!valid)
	    getDateBox().getTextBox().addStyleName(TitleStyleNames.PINK_BOX_STYLE);
	return valid;
    }

    public NoClickDateBox getDateBox() {
	return (NoClickDateBox) getWidget();
    }

    @Override
    public void setValue(String value) {
	try {
      if (value.isEmpty()){
        getDateBox().setValue(null);
        getDateBox().getTextBox().removeStyleName(TitleStyleNames.PINK_BOX_STYLE);
      }
      else
 	    getDateBox().setValue(dateFormater.parse(stripTime(value)));
	} catch (IllegalArgumentException e) {
	    return;
	}
    }

    /**
     * converts from date format "yyyy-MM-dd" to "yyyy-MM-ddTHH:mm:ss.SSS"
     * 
     * @param date
     *            the date to convert
     * @return
     */
    private String addTime(String date) {
	String suffix = "T00:00:00.000";
	return date + suffix;
    }

    /**
     * converts from date format "yyyy-MM-ddTHH:mm:ss.SSSZZZZ" to "yyyy-MM-dd"
     * 
     * @param date
     *            the date to convert
     * @return
     */
    private String stripTime(String date) {
	if (date.length() > 10)
	    return date.substring(0, 10);
	else
	    return date;
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Date> handler) {
	return getDateBox().addValueChangeHandler(handler);
    }

}
