package com.tandbergtv.cms.portal.ui.title.client.criteria.data;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.event.shared.HandlerRegistration;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.events.RHSValueChangeEvent;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.events.RHSValueChangeHandler;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.events.RHSValueDeleteEvent;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.events.RHSValueDeleteHandler;
import com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;

public class ValueList extends RHSValueWidget {

	private List<ValueListRow> rows = new ArrayList<ValueListRow>();
	private HandlerRegistration currentHandler;
	private BaseOperator operator;
	private IFieldTreeObject treeObject;

	public ValueList(IFieldTreeObject treeObject, BaseOperator operator) {
		super();
		this.treeObject = treeObject;
		this.operator = operator;
		createEmptyList();
	}

	public ValueList(IFieldTreeObject treeObject, BaseOperator operator,
			List<String> values) {
		super();
		this.treeObject = treeObject;
		this.operator = operator;
		if(values == null || values.isEmpty()) {
			createEmptyList();
		} else {
			for (int i = 0; i < values.size(); i++) {
				SingleValueWidget val = RHSWidgetFactory.getRHSWidget(treeObject,
						operator, values.get(i));
				boolean showX = i != 0;
				addRow(val, showX);
			//	setListener();
			}
			addEmptyRow();
		}
	}
	
	private void createEmptyList() {
		addRow(RHSWidgetFactory.getRHSWidget(treeObject, operator, ""), false);
		addEmptyRow();
	}

	private void setListener() {
		if (currentHandler != null) {
			currentHandler.removeHandler();
		}

		currentHandler = rows.get(rows.size() - 1).addValueChangeHandler(
				new RHSValueChangeHandler() {

					@Override
					public void onChange(RHSValueChangeEvent event) {
						addEmptyRow();
						setListener();
					}

				});
	}

	private void addEmptyRow() {
		addRow(RHSWidgetFactory.getRHSWidget(treeObject, operator, ""), false);
		if(rows.size() > 2) {
			rows.get(rows.size() - 2).setXVisible(true);
		}
		setListener();
	}

	private void addRow(SingleValueWidget value, boolean showX) {
		ValueListRow row = new ValueListRow(value, showX);
		rows.add(row);
		row.addDeleteHandler(new RHSValueDeleteHandler() {

			@Override
			public void onDelete(RHSValueDeleteEvent event) {
				rows.remove(event.getRow());
				remove(event.getRow());
			}
			
		});
		add(row);
	}

	public List<String> getValues() {
		List<String> results = new ArrayList<String>();
		for (int i = 0; i < rows.size() - 1; i++) {
			ValueListRow row = rows.get(i);
			results.add(row.getValue().trim());
		}
		return results;
	}

	public boolean validate() {
		boolean result=true;
		for (int i = 0; i < rows.size() - 1; i++) {
			if (!rows.get(i).getValueWidget().validate())
				result = false;
		}
		return result;
	}

  @Override
  public void setValues(String value) {
    // TODO Auto-generated method stub
    
  }
}
