package com.tandbergtv.cms.portal.ui.title.client.criteria.data;

import java.util.Collection;

import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.tandbergtv.cms.portal.ui.title.client.TitleStyleNames;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.events.RHSValueChangeEvent;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.IRulesValidator;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ComboBoxWidget;

/**
 * Text box for supporting standard value entry for any type that has a
 * IRulesValidator.
 * 
 * @author dweiner
 * 
 */
public class ValueTextBox extends SingleValueWidget {

    private static final String OTHER = "PARANOID_OTHER";
    private HorizontalPanel panel = new HorizontalPanel();
    private ComboBoxWidget<String> suggestedValues;
    private TextBox valueBox;
    private IRulesValidator validator;

    public ValueTextBox(IRulesValidator validator, Collection<UIValueOption> suggestedValues, boolean supportsOther) {
	this.validator = validator;
	buildSuggestedValues(suggestedValues, supportsOther);
	buildUI(supportsOther);
    }

    public ValueTextBox(IRulesValidator validator) {
	super();
	this.validator = validator;
	suggestedValues = null;
	buildUI(false);
    }

    public ValueTextBox(IRulesValidator validator, String value) {
	this(validator);
	setValue(value);
    }

    public ValueTextBox(IRulesValidator validator, Collection<UIValueOption> suggestedValues, boolean supportsOther,
	    String value) {
	this(validator, suggestedValues, supportsOther);
	setValue(value);
    }

    private void buildSuggestedValues(Collection<UIValueOption> options, boolean supportsOther) {
	suggestedValues = new ComboBoxWidget<String>();
	for (UIValueOption sg : options)
	    suggestedValues.addItem(supportsOther ? sg.getValue() : sg.getName(), sg.getValue());
    }

    public void buildUI(boolean supportsOther) {
	// TODO IMPLIMENT CHANGE LOGIC
	valueBox = new TextBox();
	valueBox.setTitle(validator.getToolTip());
	valueBox.addStyleName("small-txt");

	valueBox.addKeyPressHandler(new KeyPressHandler() {

	    @Override
	    public void onKeyPress(KeyPressEvent event) {
		fireEvent(new RHSValueChangeEvent());
	    }

	});
	valueBox.addChangeHandler(new ChangeHandler() {

	    @Override
	    public void onChange(ChangeEvent event) {
		valueBox.setValue(validator.normalize(valueBox.getValue()), false);
		validate();
		fireEvent(new RHSValueChangeEvent());

	    }
	});
	if (suggestedValues != null) {
	    panel.add(suggestedValues);
	    suggestedValues.setStyleName("rhs-value-combobox");
	    valueBox.setVisible(false);
	    suggestedValues.setEditable(supportsOther);
	    suggestedValues.addChangeHandler(new ChangeHandler() {

		@Override
		public void onChange(ChangeEvent event) {
		    clearErrorState();
		    fireEvent(new RHSValueChangeEvent());
		}

	    });
	    suggestedValues.addSelectionHandler(new SelectionHandler<String>() {

		@Override
		public void onSelection(SelectionEvent<String> event) {
		    clearErrorState();
		    fireEvent(new RHSValueChangeEvent());
		    suggestedValues.getParent().fireEvent(new RHSValueChangeEvent());

		}
	    });
	}

	panel.add(valueBox);
	setWidget(panel);
    }

    private String getSuggestedValue() {
	int index = suggestedValues.getSelectedIndex();
	if (index == -1) {
	    if (suggestedValues.getText() != null) {
		return suggestedValues.getText();
	    } else {
		return "";
	    }
	}

	return suggestedValues.getItem(index);
    }

    @Override
    public boolean validate() {
	clearErrorState();
	boolean valid;
	if (suggestedValues != null && !getSuggestedValue().equals(OTHER)) {
	    valid = !getSuggestedValue().equals("");
	    if (!valid) {
		suggestedValues.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
		suggestedValues.setSelectedIndex(0);
	    }
	} else {
	    valid = !getValue().isEmpty() && validator.validate(valueBox.getValue());
	    if (!valid) {
		valueBox.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
	    }
	}
	return valid;
    }

    private void clearErrorState() {
	valueBox.removeStyleName(TitleStyleNames.PINK_BOX_STYLE);
	if (suggestedValues != null)
	    suggestedValues.removeStyleName(TitleStyleNames.PINK_BOX_STYLE);
    }

    @Override
    public void setValue(String value) {
	if (suggestedValues != null) {
	    boolean found = false;
	    int length = suggestedValues.getItemCount();
	    int i = 0;

	    while (!found && i < length) {
		if (suggestedValues.getItem(i).equals(value)) {
		    found = true;
		    suggestedValues.setSelectedIndex(i);
		}
		i++;
	    }
	    if (!found) {
		suggestedValues.setText(value);
	    }
	} else {
	    valueBox.setValue(validator.normalize(value), false);
	    validate();
	    valueBox.setVisible(true);
	}
    }

    @Override
    public String getValue() {
	if (suggestedValues != null && !getSuggestedValue().equals(OTHER)) {
	    return getSuggestedValue();
	}
	return valueBox.getText();

    }

    @Override
    public HandlerRegistration addBlurHandler(BlurHandler handler) {
	return valueBox.addBlurHandler(handler);
    }
}
