package com.tandbergtv.cms.portal.ui.title.client.criteria.regex;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DecoratedPopupPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class RegexEditor extends DecoratedPopupPanel {
	protected final UiRegexValidatorAsync regexService = GWT
			.create(UiRegexValidator.class);

	private TextBox regexBox;
	private TextBox valueBox;
	private Label validLabel;
	private Label resultValue;

	public RegexEditor() {
		super(false, true);
		buildUi();
	}

	public RegexEditor(String regex) {
		this();
		setRegex(regex);
	}

	public void setRegex(String regex) {
		regexBox.setValue(regex);
		validLabel.setText("");
		resultValue.setText("");
	}

	private void buildUi() {
		regexBox = new TextBox();
		regexBox.setWidth("550px");
		valueBox = new TextBox();
		valueBox.setWidth("550px");
		validLabel = new Label();
		resultValue = new Label();

		FlexTable container = new FlexTable();
		container.setWidget(0, 0, new Label("Regular Expression"));
		container.setWidget(0, 1, regexBox);
		container.setWidget(1, 0, new Label("Sample Value"));
		container.setWidget(1, 1, valueBox);
		container.setWidget(2, 0, new Label("Validation check:"));
		container.setWidget(2, 1, validLabel);
		container.setWidget(3, 0, new Label("Result of regex:"));
		container.setWidget(3, 1, resultValue);

		HorizontalPanel buttonPanel = new HorizontalPanel();
		buttonPanel.addStyleName(StyleNames.STYLE_CMS_BUTTON_CONTAINER);
		Button proceed = new Button("Proceed");
		proceed.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
		proceed.addStyleName(StyleNames.STYLE_EB_BTN);
		proceed.addClickHandler(getProceedClickHandler());
		Button tryRegex = new Button("Try It Out");
		tryRegex.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
		tryRegex.addStyleName(StyleNames.STYLE_EB_BTN);
		tryRegex.addClickHandler(getCheckClickHandler());
		Button cancel = new Button("Cancel");
		cancel.removeStyleName(StyleNames.STYLE_GWT_BUTTON);
		cancel.addStyleName(StyleNames.STYLE_EB_BTN);
		cancel.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				hide();
			}
		});

		buttonPanel.add(tryRegex);
		buttonPanel.add(proceed);
		buttonPanel.add(cancel);

		VerticalPanel verticalContainer = new VerticalPanel();
		verticalContainer.add(container);
		verticalContainer.add(buttonPanel);

		setWidget(verticalContainer);
	}

	private ClickHandler getProceedClickHandler() {
		return new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				regexService.validateRegex(regexBox.getValue(),
					new NeptuneAsyncCallback<Boolean>() {

						@Override
						public void onNeptuneFailure(Throwable caught) {
							Window.alert("Unexpected error while validating regular expression");
						}

						@Override
						public void onNeptuneSuccess(Boolean result) {
							if (result) {
								RegexDoneEvent event = new RegexDoneEvent(
										regexBox.getValue());
								fireEvent(event);
								hide();
							} else {
								validLabel
										.setText("The regular expression is invalid.");
								validLabel.addStyleName("red-txt");
								resultValue.setText("");
							}
						}

					});
			}

		};
	}

	private ClickHandler getCheckClickHandler() {
		return new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				regexService.tryRegex(regexBox.getValue(), valueBox.getValue(),
						new NeptuneAsyncCallback<Boolean>() {

							@Override
							public void onNeptuneFailure(Throwable caught) {
								if (caught instanceof UiRegexValidationException) {
									validLabel
											.setText("The regular expression is invalid.");
									validLabel.addStyleName("red-txt");
								} else {
									Window
											.alert("Unexpected error while validating regular expression");
								}
							}

							@Override
							public void onNeptuneSuccess(Boolean result) {
								validLabel
										.setText("The regular expression is valid.");
								validLabel.removeStyleName("red-txt");
								resultValue.setText(result.toString());
							}

						});
			}

		};
	}

	public HandlerRegistration addRegexDoneHandler(RegexDoneHandler handler) {
		return addHandler(handler, RegexDoneEvent.TYPE);
	}
}
