/*
 * Created on Feb 20, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.ui.title.client.model.datatype;


/**
 * UI Model class representing the 'boolean' data type for the field value.
 * 
 * @author Vijay Silva
 */
public class BooleanDataType extends UIFieldDataType {

	/** The name of the data type */
	public static final String NAME = "boolean";

	/**
	 * The boolean data type for UIField values
	 */
	public BooleanDataType() {
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return NAME;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDisplayName() {
		return (NAMES != null) ? NAMES.booleanName() : getName();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void accept(IUIFieldDataTypeVisitor visitor) {
		visitor.visit(this);
	}
}
