/*
 * Created on Feb 20, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.ui.title.client.model.datatype;

/**
 * UI Model class representing the 'date' data type for the field value.
 * 
 * @author Vijay Silva
 */
public class DateDataType extends UIFieldDataType {

	/** The name of the data type */
	public static final String NAME = "date";

	/**
	 * The boolean data type for UIField values
	 */
	public DateDataType() {
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return NAME;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDisplayName() {
		return (NAMES != null) ? NAMES.dateName() : getName();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void accept(IUIFieldDataTypeVisitor visitor) {
		visitor.visit(this);
	}
}
