/*
 * Created on Feb 20, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.ui.title.client.model.datatype;

/**
 * UI Model class representing the 'integer' data type for the field value.
 * 
 * @author Vijay Silva
 */
public class IntegerDataType extends UIFieldDataType {

	/** The name of the data type */
	public static final String NAME = "integer";

	/**
	 * Constructor - The integer data type for UIField values
	 */
	public IntegerDataType() {
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return NAME;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDisplayName() {
		return (NAMES != null) ? NAMES.integerName() : getName();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void accept(IUIFieldDataTypeVisitor visitor) {
		visitor.visit(this);
	}
}
