package com.tandbergtv.cms.portal.ui.title.client.model.search;

import java.util.List;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class MessageContainer extends VerticalContainer {

	/**
	 * Constructor
	 */
	public MessageContainer() {
		super();
	}

	/**
	 * Adds a Label widget to the bottom of this widget containing the text in
	 * the message with "information-dialogue" styling.
	 * 
	 * @param message
	 *            The message.
	 */
	public void addMessage(String message, boolean clearFirst) {
		if(clearFirst) {
			clear();
		}
		
		LabelWidget label = new LabelWidget(message);
		label.setStyleName("information-dialogue");
		this.add(label);
	}
	
	/**
	 * Adds a Label widget to the bottom of this widget containing the text of
	 * each String in the messages List with "information-dialogue" styling.
	 * 
	 * @param messages
	 *            The list of messages.
	 */
	public void addMessages(List<String> messages, boolean clearFirst) {
		if(clearFirst) {
			clear();
		}
		
		for (String message : messages) {
			LabelWidget label = new LabelWidget(message);
			label.setStyleName("information-dialogue");
			this.add(label);
		}
	}

	/**
	 * Adds a Label widget to the bottom of this widget containing the text in
	 * the message with "red-txt" styling.
	 * 
	 * @param message
	 *            The message.
	 */
	public void addErrorMessage(String message, boolean clearFirst) {
		if(clearFirst) {
			clear();
		}
		
		LabelWidget label = new LabelWidget(message);
		label.setStyleName("information-dialogue");
		label.addStyleName("red-txt");
		this.add(label);
	}

	/**
	 * Adds a Label widget to the bottom of this widget containing the text of
	 * each String in the messages List with "red-txt" styling.
	 * 
	 * @param messages
	 *            The list of messages.
	 */
	public void addErrorMessages(List<String> messages, boolean clearFirst) {
		if(clearFirst) {
			clear();
		}
		
		for (String message : messages) {
			LabelWidget label = new LabelWidget(message);
			label.setStyleName("information-dialogue");
			label.addStyleName("red-txt");
			this.add(label);
		}
	}

}
