package com.tandbergtv.cms.portal.ui.title.client.model.search;

import java.util.List;

import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.PMMTitleTreeObject;

public class RulesOperatorLimited extends BaseOperator {

	public RulesOperatorLimited() {

	}

	@Override
	protected List<BaseOperator> complexDataType(IFieldTreeObject obj) {
		SoArrayList result = (SoArrayList) super.complexDataType(obj);
		addInstanceCountOps(result, obj);
		addFieldInvalidOperator(obj.getField(), result);
		return result;
	}

	@Override
	protected List<BaseOperator> integerDataType(IFieldTreeObject obj) {
		SoArrayList result = (SoArrayList) super.integerDataType(obj);
		addInstanceCountOps(result, obj);
		result.add(BaseOperator.REGEX);
		return result;
	}

	@Override
	protected List<BaseOperator> floatDataType(IFieldTreeObject obj) {
		SoArrayList result = (SoArrayList) super.floatDataType(obj);
		addInstanceCountOps(result, obj);
		result.add(BaseOperator.REGEX);
		return result;
	}

	@Override
	protected List<BaseOperator> timeDataType(IFieldTreeObject obj) {
		SoArrayList result = (SoArrayList) super.timeDataType(obj);
		addInstanceCountOps(result, obj);
		result.add(BaseOperator.REGEX);
		return result;
	}

	public static BaseOperator lookup(String operator) {
		return BaseOperator.lookup(operator);
	}

	@Override
	protected List<BaseOperator> stringDataType(IFieldTreeObject obj) {
		SoArrayList result = (SoArrayList) super.stringDataType(obj);
		result.add(BaseOperator.LENGTHEQUALS);
		result.add(BaseOperator.LENGTHGREATERTHAN);
		result.add(BaseOperator.LENGTHLESSTHAN);
		result.add(BaseOperator.TOTALLENGTHEQUALS);
		result.add(BaseOperator.TOTALLENGTHGREATERTHAN);
		result.add(BaseOperator.TOTALLENGTHLESSTHAN);
		addInstanceCountOps(result, obj);
		result.add(BaseOperator.REGEX);
		addCategoryOperators(obj.getField(), result);
		addFieldInvalidOperator(obj.getField(), result);
		return result;
	}

	@Override
	protected List<BaseOperator> booleanDataType(IFieldTreeObject obj) {
		SoArrayList result = (SoArrayList) super.booleanDataType(obj);
		addInstanceCountOps(result, obj);
		return result;
	}
	
	@Override
	protected List<BaseOperator> dateDataType(IFieldTreeObject obj) {
		SoArrayList result = (SoArrayList) super.dateDataType(obj);
		addInstanceCountOps(result, obj);
		result.add(BaseOperator.TIMEEQUALS);
		result.add(BaseOperator.TIMEGREATERTHAN);
		result.add(BaseOperator.TIMELESSTHAN);
		return result;
	}
	
	private void addInstanceCountOps(SoArrayList result, IFieldTreeObject obj) {
		if(!(obj instanceof PMMTitleTreeObject)) {
			result.add(BaseOperator.NUMINSTANCESEQUAL);
			result.add(BaseOperator.NUMINSTANCESGREATERTHAN);
			result.add(BaseOperator.NUMINSTANCESLESSTHAN);
		}
	}
}
