/**
 * 
 */
package com.tandbergtv.cms.portal.ui.title.client.model.search;

import java.util.Collection;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;

/**
 * Main class that represents the Title Filter UI Model
 * 
 * @author vaibhav
 */
public class UITitleFilter implements IsSerializable {

	public IUITitleFilterNode rootNode;

	// paging info
	private UiPageInfo pageInfo;
	private boolean includeCount;

	// sorting info
	private UiSortInfo sortInfo;

	private UiCriteriaMode criteriaMode;
	
	//NOT PERSISTED (used for integration between rules and search)
	private Collection<Integer> filterSiteIds;

	public UITitleFilter() {
		super();
		this.sortInfo = new UiSortInfo();
		this.pageInfo = new UiPageInfo();
		criteriaMode = UiCriteriaMode.EPISODE;
	}

	public UITitleFilter(IUITitleFilterNode rootNode,
			String sortColumnName, String sortColumnSection, UISortOrder sortOrder,
			UIFieldType sortFieldType, UiCriteriaMode criteriaMode)  {
		super();
		this.sortInfo = new UiSortInfo(sortColumnName, sortColumnSection, sortOrder, sortFieldType);
		this.pageInfo = new UiPageInfo();
		this.rootNode = rootNode;
		this.setCriteriaMode(criteriaMode);
	}

	/**
	 * @return the rootNode
	 */
	public IUITitleFilterNode getRootNode() {
		return rootNode;
	}

	/**
	 * @param rootNode
	 *            the rootNode to set
	 */
	public void setRootNode(IUITitleFilterNode rootNode) {
		this.rootNode = rootNode;
	}
	
	public UiPageInfo getPageInfo() {
		return pageInfo;
	}

	public void setPageInfo(UiPageInfo pageInfo) {
		this.pageInfo = pageInfo;
	}

	public UiSortInfo getSortInfo() {
		return sortInfo;
	}

	public void setSortInfo(UiSortInfo sortInfo) {
		this.sortInfo = sortInfo;
	}

	public boolean isCountIncluded() {
		return includeCount;
	}

	public void setIncludeCount(boolean includeCount) {
		this.includeCount = includeCount;
	}

	public UiCriteriaMode getCriteriaMode() {
		return criteriaMode;
	}

	public void setCriteriaMode(UiCriteriaMode criteriaMode) {
		this.criteriaMode = criteriaMode;
	}

	public Collection<Integer> getFilterSiteIds() {
		return filterSiteIds;
	}

	public void setFilterSiteIds(Collection<Integer> filterSiteIds) {
		this.filterSiteIds = filterSiteIds;
	}
	
	
}
