package com.tandbergtv.cms.portal.ui.title.client.model.search;

import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;

public abstract class UITitleFilterConditionNode implements IUITitleFilterNode {
	// whether this is a PMM_Title field or an Asset Field
	private UIFieldType fieldTypeLhs;
	/*
	 * For metadata fields, this property defines the item type (e.g. MOVIE,
	 * POSTER...) to filter by
	 */
	protected String sectionTypeLhs;

	/* internal name of the field */
	protected String fieldLhs;

	private String fieldLhsDisplayName;

	/* data type of the field */
	protected UIDataType dataType;

	/* search operator for this field */
	protected BaseOperator searchOperator;

	/* value, list or range type */
	protected UIParamType paramType;

	

	protected boolean ignoreCase;

	/* whether this has a not. As in !(x == y) */
	protected boolean not = false;
	private String complexType;
	private String extendedDisplayNameLhs;

	public UITitleFilterConditionNode() {
		super();
	}

	public UITitleFilterConditionNode(String fieldLhs, String sectionTypeLhs,
			UIFieldType fieldTypeLhs, BaseOperator operator,
			UIParamType paramType, boolean ignoreCase, boolean not,
			UIDataType dataType, String fieldLhsDisplayName, String complexType, String extendedDisplayNameLhs) {
		this.fieldLhs = fieldLhs;
		this.searchOperator = operator;
		this.sectionTypeLhs = sectionTypeLhs;
		this.fieldTypeLhs = fieldTypeLhs;
		this.paramType = paramType;
		this.ignoreCase = ignoreCase;
		this.not = not;
		this.dataType = dataType;
		this.complexType = complexType;
		this.extendedDisplayNameLhs = extendedDisplayNameLhs;
		this.setFieldLhsDisplayName(fieldLhsDisplayName);
	}

	public String getField() {
		return fieldLhs;
	}

	public void setField(String field) {
		this.fieldLhs = field;
	}

	public UIDataType getDataType() {
		return dataType;
	}

	public void setDataType(UIDataType dataType) {
		this.dataType = dataType;
	}

	public BaseOperator getSearchOperator() {
		return searchOperator;
	}

	public String getSearchOperatorString() {
		return searchOperator.toString();
	}

	public void setSearchOperator(BaseOperator searchOperator) {
		this.searchOperator = searchOperator;
	}

	public void setSearchOperator(String searchOperator) {
		this.searchOperator = BaseOperator
				.valueOf(searchOperator.toUpperCase());
	}

	public UIParamType getParamType() {
		return paramType;
	}

	public String getParamTypeString() {
		return paramType.toString();
	}

	public void setParamType(String paramType) {
		this.paramType = UIParamType.valueOf(paramType.toUpperCase());
	}

	public void setParamType(UIParamType paramType) {
		this.paramType = paramType;
	}

	/**
	 * @return the sectionType
	 */
	public String getSectionType() {
		return sectionTypeLhs;
	}

	/**
	 * @param sectionType
	 *            the sectionType to set
	 */
	public void setSectionType(String sectionType) {
		this.sectionTypeLhs = sectionType;
	}

	public boolean isIgnoreCase() {
		return ignoreCase;
	}

	public void setIgnoreCase(boolean ignoreCase) {
		this.ignoreCase = ignoreCase;
	}

	/**
	 * Sets the value not operator for this value node.
	 * 
	 * @param not
	 */
	public void setNot(boolean not) {
		this.not = not;
	}

	/**
	 * Gets the value of the not operator for this value node.
	 * 
	 * @return
	 */
	public boolean isNot() {
		return not;
	}

	public void setFieldType(UIFieldType fieldType) {
		this.fieldTypeLhs = fieldType;
	}

	public UIFieldType getFieldType() {
		return fieldTypeLhs;
	}

	public abstract RhsType getRhsType();

	public String getFieldLhsDisplayName() {
		return fieldLhsDisplayName;
	}

	public void setFieldLhsDisplayName(String fieldLhsDisplayName) {
		this.fieldLhsDisplayName = fieldLhsDisplayName;
	}

	public String getComplexType() {
		return complexType;
	}

	public String getExtendedDisplayNameLhs() {
		return extendedDisplayNameLhs;
	}

}
