package com.tandbergtv.cms.portal.ui.title.client.model.search;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * This class represents a column in the table in the UI.
 * 
 * @author spuranik
 * 
 */
public class UiColumn implements IsSerializable {

	private String name;
	private String displayName;
	private boolean sortable;
	private String sectionName;
	private boolean isRootMetadata;
	private UiColumn.DataType dataType;
	private boolean isSelectedByDefault;
	private boolean isMultiValued;
	private boolean isSelected;
	private boolean isQuickInfoField;
	private UIFieldType fieldType;

	private static String INTERNAL_NAME_DELIMITER = "|";
	
	public UiColumn() {
		super();
	}

	public UiColumn(String name, String displayName, boolean sortable,
			String sectionName, UIFieldType fieldType, boolean isRootMetadata,
			DataType dataType, boolean isSelectedByDefault, boolean isMultiValued) {
		super();
		this.name = name;
		this.displayName = displayName;
		this.sortable = sortable;
		this.sectionName = sectionName;
		this.fieldType = fieldType;
		this.isRootMetadata = isRootMetadata;
		this.dataType = dataType;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return the isRootMetadata
	 */
	public boolean isRootMetadata() {
		return isRootMetadata;
	}

	/**
	 * @param isRootMetadata the isRootMetadata to set
	 */
	public void setRootMetadata(boolean isRootMetadata) {
		this.isRootMetadata = isRootMetadata;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the displayName
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * @param displayName
	 *            the displayName to set
	 */
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	/**
	 * @return the sortable
	 */
	public boolean isSortable() {
		return sortable;
	}

	/**
	 * @param sortable
	 *            the sortable to set
	 */
	public void setSortable(boolean sortable) {
		this.sortable = sortable;
	}

	/**
	 * @return the sectionName
	 */
	public String getSectionName() {
		return sectionName;
	}

	/**
	 * @param sectionName
	 *            the sectionName to set
	 */
	public void setSectionName(String sectionName) {
		this.sectionName = sectionName;
	}

	/**
	 * Get the data type associated with this column
	 * 
	 * @return The column data type
	 */
	public UiColumn.DataType getDataType() {
	    return dataType;
    }

	/**
	 * Set the data type associated with this column
	 * 
	 * @param dataType The column data type
	 */
	public void setDataType(UiColumn.DataType dataType) {
	    this.dataType = dataType;
    }

	/*
	 * An enumeration of the data types supported for the UiColumn
	 */
	public static enum DataType implements IsSerializable {
		BOOLEAN, DATE, FLOAT, INTEGER, STRING, TIME;
	}

	public boolean isSelectedByDefault() {
		return isSelectedByDefault;
	}

	public void setSelectedByDefault(boolean isSelectedByDefault) {
		this.isSelectedByDefault = isSelectedByDefault;
	}

	public boolean isMultiValued() {
		return isMultiValued;
	}

	public void setIsMultiValued(boolean isMultiValued) {
		this.isMultiValued = isMultiValued;
	}
	
	public String getInternalName() {
		if(this.sectionName != null && !this.sectionName.isEmpty()) {
			return this.sectionName + INTERNAL_NAME_DELIMITER + this.getName();
		} else {
			return this.getName();
		}		
	}
	
	public void setInternalName(String internalName) {
		int pos = internalName.indexOf(INTERNAL_NAME_DELIMITER);
		if(pos != -1) {
			setSectionName(internalName.substring(0, pos));
			setName(internalName.substring(pos + 1));
		} else {
			setName(internalName);
		}
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		result = prime * result
				+ ((sectionName == null) ? 0 : sectionName.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		UiColumn other = (UiColumn) obj;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		if (sectionName == null) {
			if (other.sectionName != null)
				return false;
		} else if (!sectionName.equals(other.sectionName))
			return false;
		return true;
	}

	public UIFieldType getFieldType() {
		return fieldType;
	}

	public boolean isSelected() {
		return isSelected;
	}

	public void setSelected(boolean isSelected) {
		this.isSelected = isSelected;
	}

	public boolean isQuickInfoField() {
		return isQuickInfoField;
	}

	public void setQuickInfoField(boolean isQuickInfoField) {
		this.isQuickInfoField = isQuickInfoField;
	}

	public void setFieldType(UIFieldType fieldType) {
		this.fieldType = fieldType;
	}
}