/*
 * Created on Feb 23, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.ui.title.client.model.specification;

/**
 * The Visitor for the UIFieldDefinition subclasses
 * 
 * @author Vijay Silva
 */
public interface IUIFieldDefinitionVisitor {

	/**
	 * Visit a complex field definition
	 * 
	 * @param fieldDefinition The field definition to visit
	 */
	public void visit(UIComplexFieldDefinition fieldDefinition);

	/**
	 * Visit a simple boolean field definition
	 * 
	 * @param assetDefinition The field definition to visit
	 */
	public void visit(UIBooleanFieldDefinition fieldDefinition);

	/**
	 * Visit a simple integer field definition
	 * 
	 * @param assetDefinition The field definition to visit
	 */
	public void visit(UIIntegerFieldDefinition fieldDefinition);

	/**
	 * Visit a simple float field definition
	 * 
	 * @param assetDefinition The field definition to visit
	 */
	public void visit(UIFloatFieldDefinition fieldDefinition);

	/**
	 * Visit a simple date field definition
	 * 
	 * @param assetDefinition The field definition to visit
	 */
	public void visit(UIDateFieldDefinition fieldDefinition);

	/**
	 * Visit a simple time field definition
	 * 
	 * @param assetDefinition The field definition to visit
	 */
	public void visit(UITimeFieldDefinition fieldDefinition);

	/**
	 * Visit a simple string field definition
	 * 
	 * @param assetDefinition The field definition to visit
	 */
	public void visit(UIStringFieldDefinition fieldDefinition);
}
