/*
 * Created on Feb 20, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.ui.title.client.model.specification;

import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * UI Model class that represents an Asset Definition (for a specification)
 * 
 * @author Vijay Silva
 */
public abstract class UIAssetDefinition implements IsSerializable {

	/** The name of the root field used in all assets */
	public static final String ROOT_FIELD_NAME = "Metadata";

	/* Properties */
	private UIAssetSpecification specification;
	private UIAssetDefinition parent;
	private String displayName;
	private int minimumCount = 1;
	private int maximumCount = 1;
	private int batchMinimumCount = 0;
	private int batchMaximumCount = 0;
	private UIComplexFieldDefinition rootFieldDefinition;
	private UIAssetFileDefinition fileDefinition;
	private boolean filesAllowed;
	private boolean hideFileView;
	// Path to this asset from the root, e.g. PACKAGE/MOVIE. This field is used to map UIAssetDefinition to a Content Class Asset.
	private String path;

	/**
	 * Constructor
	 */
	public UIAssetDefinition() {
		rootFieldDefinition = new UIComplexFieldDefinition();
		rootFieldDefinition.setAssetDefinition(this);
		rootFieldDefinition.setDisplayName(ROOT_FIELD_NAME);
		rootFieldDefinition.setName(ROOT_FIELD_NAME);
	}

	/**
	 * @return the specification
	 */
	public UIAssetSpecification getSpecification() {
		return specification;
	}

	/**
	 * @param specification the specification to set
	 */
	public void setSpecification(UIAssetSpecification specification) {
		this.specification = specification;
	}

	/**
	 * @return the parent
	 */
	public UIAssetDefinition getParentDefinition() {
		return parent;
	}

	/**
	 * @param parent the parent to set
	 */
	public void setParentDefinition(UIAssetDefinition parent) {
		this.parent = parent;
	}

	/**
	 * @return the displayName
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * @param displayName the displayName to set
	 */
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	/**
	 * Get the asset type (or definition name) for this asset definition
	 * 
	 * @return The asset type
	 */
	public abstract String getAssetType();

	/**
	 * @return the minimumCount
	 */
	public int getMinimumCount() {
		return minimumCount;
	}

	/**
	 * @param minimumCount the minimumCount to set
	 */
	public void setMinimumCount(int minimumCount) {
		if (minimumCount < 0)
			minimumCount = 0;

		this.minimumCount = minimumCount;
	}

	/**
	 * @return the maximumCount
	 */
	public int getMaximumCount() {
		return maximumCount;
	}

	/**
	 * @param maximumCount the maximumCount to set
	 */
	public void setMaximumCount(int maximumCount) {
		/* If max count is unlimited, set to MAX_VALUE. Ensure that max count is not 0 */
		if (maximumCount < 0)
			maximumCount = Integer.MAX_VALUE;
		else if (maximumCount == 0)
			maximumCount = 1;

		this.maximumCount = maximumCount;
	}

	/**
	 * @return the batchMinimumCount
	 */
	public int getBatchMinimumCount() {
		return batchMinimumCount;
	}

	/**
	 * @param batchMinimumCount the batchMinimumCount to set
	 */
	public void setBatchMinimumCount(int batchMinimumCount) {
		if (batchMinimumCount < 0)
			batchMinimumCount = 0;

		this.batchMinimumCount = batchMinimumCount;
	}

	/**
	 * @return the batchMaximumCount
	 */
	public int getBatchMaximumCount() {
		return batchMaximumCount;
	}

	/**
	 * @param batchMaximumCount the batchMaximumCount to set
	 */
	public void setBatchMaximumCount(int batchMaximumCount) {
		/* If max count is unlimited, set to MAX_VALUE. 0 is allowed for maximum batch count */
		if (batchMaximumCount < 0)
			batchMaximumCount = Integer.MAX_VALUE;

		this.batchMaximumCount = batchMaximumCount;
	}

	/**
	 * @return the field definitions
	 */
	public UIComplexFieldDefinition getRootFieldDefinition() {
		return this.rootFieldDefinition;
	}

	/**
	 * @return the fileDefinition
	 */
	public UIAssetFileDefinition getFileDefinition() {
		return fileDefinition;
	}

	/**
	 * @param fileDefinition the fileDefinition to set
	 */
	public void setFileDefinition(UIAssetFileDefinition fileDefinition) {
		if (fileDefinition != null) {
			fileDefinition.setParent(this);
		}

		this.fileDefinition = fileDefinition;
	}

	/**
	 * Check if files are allowed for this asset definition
	 * 
	 * @return true if files are allowed, false otherwise
	 */
	public boolean isFilesAllowed() {
		return filesAllowed;
	}

	/**
	 * @param filesAllowed the filesAllowed to set
	 */
	public void setFilesAllowed(boolean filesAllowed) {
		this.filesAllowed = filesAllowed;
	}

	/**
	 * Accepts the visitor for this asset definition
	 * 
	 * @param visitor The visitor
	 */
	public abstract void accept(IUIAssetDefinitionVisitor visitor);
	
	/**
	 * Finds UIAssetFileFieldDefinition by XPath parameter
	 * @param xPath
	 * @return
	 */
	public UIAssetFileFieldDefinition findUIAssetFileFieldDefinitionByXPath(String xPath) {
		List<UIAssetFileFieldDefinition> defs = fileDefinition.getFieldDefinitions();
		
		for(UIAssetFileFieldDefinition def: defs) {
			if(xPath.equals(def.getFieldDefinition().getXPath())) {
				return def;
			}
		}
		
		return null;
	}

	/**
	 * Gets path to this asset from the root, e.g. PACKAGE/MOVIE. 
	 * The path is used to map UIAssetDefinition to a Content Class Asset. 
	 * @return
	 */
	public String getPath() {
		return path;
	}

	/**
	 * Gets path to this asset from the root, e.g. PACKAGE/MOVIE.
	 * @param path
	 */
	public void setPath(String path) {
		this.path = path;
	}

	/**
	 * Sets the visibility of the file view
	 * @param hideFileView
	 */
	public void setHideFileView(boolean hideFileView) {
		this.hideFileView = hideFileView;
	}

	public boolean isHideFileView() {
		return hideFileView;
	}
	
	
}
