/*
 * Created on Mar 12, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.ui.title.client.model.specification;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Defines the File asset
 * 
 * @author Vijay Silva
 */
public class UIAssetFileDefinition implements IsSerializable {

	/* Properties */
	private UIAssetDefinition parent;
	private List<UIAssetFileFieldDefinition> fields = new ArrayList<UIAssetFileFieldDefinition>();

	/**
	 * Constructor
	 */
	public UIAssetFileDefinition() {
	}

	/**
	 * @return the parent
	 */
	public UIAssetDefinition getParent() {
		return parent;
	}

	/**
	 * @param parent the parent to set
	 */
	public void setParent(UIAssetDefinition parent) {
		this.parent = parent;
	}

	/**
	 * @return the fields
	 */
	public List<UIAssetFileFieldDefinition> getFieldDefinitions() {
		return fields;
	}

	/**
	 * Add a Field definition to the list of field definitions
	 * 
	 * @param definition The field definition to add
	 */
	public void addFieldDefinition(UIAssetFileFieldDefinition definition) {
		if (definition != null) {
			definition.setAssetFileDefinition(this);
			this.fields.add(definition);
		}
	}
}
