/*
 * Created on Mar 12, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.ui.title.client.model.specification;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;

/**
 * Contains the definition of a Field present in a Asset File.
 * 
 * @author Vijay Silva
 */
public class UIAssetFileFieldDefinition implements IsSerializable {

	/* Properties */
	private UIAssetFileDefinition assetFileDefinition;
	private UISimpleFieldDefinition fieldDefinition;

	/**
	 * Constructor
	 */
	public UIAssetFileFieldDefinition() {
	}

	/**
	 * @return the assetFileDefinition
	 */
	public UIAssetFileDefinition getAssetFileDefinition() {
		return assetFileDefinition;
	}

	/**
	 * @param assetFileDefinition the assetFileDefinition to set
	 */
	public void setAssetFileDefinition(UIAssetFileDefinition assetFileDefinition) {
		this.assetFileDefinition = assetFileDefinition;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return (fieldDefinition != null) ? fieldDefinition.getName() : null;
	}

	/**
	 * @return the displayName
	 */
	public String getDisplayName() {
		return (fieldDefinition != null) ? fieldDefinition.getDisplayName() : null;
	}

	/**
	 * @return the data type
	 */
	public UIFieldDataType getDatatype() {
		return (fieldDefinition != null) ? fieldDefinition.getDatatype() : null;
	}

	/**
	 * @return the fieldDefinition
	 */
	public UISimpleFieldDefinition getFieldDefinition() {
		return fieldDefinition;
	}

	/**
	 * @param fieldDefinition the fieldDefinition to set
	 */
	public void setFieldDefinition(UISimpleFieldDefinition fieldDefinition) {
		this.fieldDefinition = fieldDefinition;
	}
}
