/*
 * Created on Feb 19, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.ui.title.client.model.specification;

import java.util.ArrayList;
import java.util.List;

/**
 * UI Model object that represents a complex field definition. A complex field definition is made up
 * of other field definitions which can be simple field definitions or be other complex field
 * definitions.
 * 
 * @author Vijay Silva
 */
public class UIComplexFieldDefinition extends UIFieldDefinition {

	/* Properties */
	private boolean showCollapsed = false;
	private List<UIFieldDefinition> children = new ArrayList<UIFieldDefinition>();
	private boolean artificial = false;

	/**
	 * Default constructor
	 */
	public UIComplexFieldDefinition() {
	}

	/**
	 * Set the parent asset definition for this field definition and all its children
	 * 
	 * @see com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition#setAssetDefinition(com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition)
	 */
	@Override
	public void setAssetDefinition(UIAssetDefinition parent) {
		super.setAssetDefinition(parent);

		for (UIFieldDefinition child : children)
			child.setAssetDefinition(parent);
	}

	/**
	 * @return the showCollapsed
	 */
	public boolean isShowCollapsed() {
		return showCollapsed;
	}

	/**
	 * @param showCollapsed the showCollapsed to set
	 */
	public void setShowCollapsed(boolean showCollapsed) {
		this.showCollapsed = showCollapsed;
	}

	/**
	 * @return the children
	 */
	public List<UIFieldDefinition> getChildren() {
		return children;
	}

	/**
	 * @param children the children to set
	 */
	public void setChildren(List<UIFieldDefinition> children) {
		if (children != null) {
			for (UIFieldDefinition child : children) {
				child.setParent(this);
				child.setAssetDefinition(this.getAssetDefinition());
			}
		}

		this.children = (children != null) ? children : new ArrayList<UIFieldDefinition>();
	}

	/**
	 * Add a child field definition to this complex field definition
	 * 
	 * @param fieldDefinition the field definition
	 */
	public void addChild(UIFieldDefinition fieldDefinition) {
		if (fieldDefinition != null) {
			fieldDefinition.setParent(this);
			fieldDefinition.setAssetDefinition(this.getAssetDefinition());
			this.children.add(fieldDefinition);
		}
	}

	@Override
	public boolean isBatch() {
		for (UIFieldDefinition child : this.children) {
			if (child.isBatch()) {
				return true;
			}
		}

		return false;
	}

	/**
	 * @return the artificial
	 */
	public boolean isArtificial() {
		return artificial;
	}

	/**
	 * @param artificial the artificial to set
	 */
	public void setArtificial(boolean artificial) {
		this.artificial = artificial;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void accept(IUIFieldDefinitionVisitor visitor) {
		visitor.visit(this);
	}
	
	public boolean hasChildren()
	{
		return (children != null && !children.isEmpty());
	}
}
