/*
 * Created on Jun 3, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.cms.portal.ui.title.client.model.specification;

import com.tandbergtv.cms.portal.ui.title.client.model.datatype.DateDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;

/**
 * Field definition for a simple field that contains a date value
 * 
 * @author Vijay Silva
 */
public class UIDateFieldDefinition extends UISimpleFieldDefinition {

	private UIFieldDataType datatype = new DateDataType();
	private String displayFormat;

	/** The pattern that the value must obey for a field instance of this definition */
	public static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";

	/**
	 * {@inheritDoc}
	 */
	@Override
	public UIFieldDataType getDatatype() {
		return this.datatype;
	}


	/**
	 * @return the display format to use when displaying a value
	 */
	public String getDisplayFormat() {
		return displayFormat;
	}

	/**
	 * @param format the display format to set
	 */
	public void setDisplayFormat(String format) {
		this.displayFormat = format;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void accept(IUIFieldDefinitionVisitor visitor) {
		visitor.visit(this);
	}
}
